/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.registry.itemGeneration;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.userofbricks.expanded_combat.api.NonNullTriConsumer;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.MaterialBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.MaterialItemBuilder;
import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECConfigBooleanCondition;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECMaterialBooleanCondition;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class GauntletItemBuilder
extends MaterialItemBuilder {
    public static final List<TrimModelData> GENERATED_TRIM_MODELS = List.of(new TrimModelData("quartz", 0.1f, Map.of()), new TrimModelData("iron", 0.2f, Map.of("Iron", "iron_darker")), new TrimModelData("netherite", 0.3f, Map.of("Netherite", "netherite_darker")), new TrimModelData("redstone", 0.4f, Map.of()), new TrimModelData("copper", 0.5f, Map.of()), new TrimModelData("gold", 0.6f, Map.of("Gold", "gold_darker")), new TrimModelData("emerald", 0.7f, Map.of()), new TrimModelData("diamond", 0.8f, Map.of("Diamond", "diamond_darker")), new TrimModelData("lapis", 0.9f, Map.of()), new TrimModelData("amethyst", 1.0f, Map.of()));
    public final MaterialBuilder materialBuilder;
    public final Material material;
    public final Material craftedFrom;
    public final ItemBuilder<? extends Item, Registrate> itemBuilder;
    private String lang = "";
    private NonNullTriConsumer<ItemBuilder<? extends Item, Registrate>, Material, Boolean> modelBuilder;
    private NonNullTriConsumer<ItemBuilder<? extends Item, Registrate>, Material, @Nullable Material> recipeBuilder;
    private NonNullConsumer<ItemBuilder<? extends Item, Registrate>> colorBuilder;

    public GauntletItemBuilder(MaterialBuilder materialBuilder, Registrate registrate, Material material, Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends Item> constructor) {
        ItemBuilder itemBuilder = registrate.item(material.getLocationName().m_135815_() + "_gauntlet", p -> (Item)constructor.apply(p, (Object)material));
        itemBuilder.tag(new TagKey[]{ECItemTags.GAUNTLETS, ItemTags.f_265942_});
        this.material = material;
        this.itemBuilder = itemBuilder;
        this.materialBuilder = materialBuilder;
        this.craftedFrom = craftedFrom;
        this.lang = material.getName() + " Gauntlet";
        this.modelBuilder = GauntletItemBuilder::generateModel;
        this.recipeBuilder = GauntletItemBuilder::generateRecipes;
        this.colorBuilder = GauntletItemBuilder::colors;
    }

    public GauntletItemBuilder lang(String englishName) {
        this.lang = englishName;
        return this;
    }

    public GauntletItemBuilder model(NonNullTriConsumer<ItemBuilder<? extends Item, Registrate>, Material, Boolean> modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public GauntletItemBuilder recipes(NonNullTriConsumer<ItemBuilder<? extends Item, Registrate>, Material, Material> recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public GauntletItemBuilder color(NonNullConsumer<ItemBuilder<? extends Item, Registrate>> colorBuilder) {
        this.colorBuilder = colorBuilder;
        return this;
    }

    public MaterialBuilder build(boolean dyeable) {
        this.itemBuilder.lang(this.lang);
        this.modelBuilder.apply(this.itemBuilder, this.material, dyeable);
        this.recipeBuilder.apply(this.itemBuilder, this.material, this.craftedFrom);
        if (dyeable) {
            this.colorBuilder.accept(this.itemBuilder);
        }
        this.materialBuilder.gauntlet((NonNullFunction<Material, RegistryEntry<? extends Item>>)((NonNullFunction)m -> this.itemBuilder.register()));
        return this.materialBuilder;
    }

    public static void colors(ItemBuilder<? extends Item, Registrate> itemBuilder) {
        itemBuilder.color(() -> () -> (stack, itemLayer) -> itemLayer == 0 ? ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack) : -1);
    }

    public static void generateModel(ItemBuilder<? extends Item, Registrate> itemBuilder, Material material, boolean dyeable) {
        String locationName = material.getLocationName().m_135815_();
        itemBuilder.model((ctx, prov) -> {
            ResourceLocation main_texture = new ResourceLocation(material.getLocationName().m_135827_(), "item/gauntlet/" + locationName);
            ResourceLocation overlay_texture = new ResourceLocation(material.getLocationName().m_135827_(), "item/gauntlet/" + locationName + "_overlay");
            ItemModelBuilder mainModel = !dyeable ? prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{main_texture}) : prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{main_texture, overlay_texture});
            for (TrimModelData trimModelData : GENERATED_TRIM_MODELS) {
                ResourceLocation trim_texture = new ResourceLocation("expanded_combat", "trims/items/gauntlet_trim_" + trimModelData.name(material));
                ItemModelBuilder trimModel = (ItemModelBuilder)((ItemModelBuilder)prov.getBuilder(prov.name((NonNullSupplier)ctx) + "_" + trimModelData.name(material) + "_trim")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
                trimModel.texture("layer0", main_texture);
                if (!dyeable) {
                    trimModel.texture("layer1", trim_texture);
                } else {
                    trimModel.texture("layer1", overlay_texture);
                    trimModel.texture("layer2", trim_texture);
                }
                mainModel.override().predicate(ItemModelGenerators.f_265922_, trimModelData.itemModelIndex()).model((ModelFile)trimModel);
            }
        });
    }

    public static void generateRecipes(ItemBuilder<? extends Item, Registrate> itemBuilder, Material material, @Nullable Material craftedFrom) {
        String name = material.getName();
        itemBuilder.recipe((ctx, prov) -> {
            boolean useCraftingItem;
            Ingredient craftingIngredient = null;
            InventoryChangeTrigger.TriggerInstance triggerInstance = null;
            boolean bl = useCraftingItem = !material.getConfig().crafting.craftingItem.isEmpty();
            if (useCraftingItem) {
                craftingIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem))});
                triggerInstance = GauntletItemBuilder.getTriggerInstance((ArrayList)Collections.singletonList(material.getConfig().crafting.craftingItem));
            } else if (!material.getConfig().crafting.repairItem.isEmpty()) {
                craftingIngredient = IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
                triggerInstance = GauntletItemBuilder.getTriggerInstance(material.getConfig().crafting.repairItem);
            }
            if (craftingIngredient != null) {
                ECConfigBooleanCondition enableGauntlets = new ECConfigBooleanCondition("gauntlet");
                ECMaterialBooleanCondition isSingleAddition = new ECMaterialBooleanCondition(name, "config", "crafting", "is_single_addition");
                HashMap<Character, Ingredient> recipe = new HashMap<Character, Ingredient>();
                recipe.put(Character.valueOf('b'), craftingIngredient);
                GauntletItemBuilder.conditionalShapedRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, new String[]{"bb", "b "}, recipe, 1, new ICondition[]{enableGauntlets, new NotCondition((ICondition)isSingleAddition)}, triggerInstance, "");
                if (craftedFrom != null) {
                    if (material.getConfig().crafting.smithingTemplate != null && !Objects.equals(material.getConfig().crafting.smithingTemplate, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)Items.f_41852_)).toString())) {
                        GauntletItemBuilder.conditionalSmithing120Recipe((DataGenContext<Item, ? extends Item>)ctx, prov, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.smithingTemplate))}), craftingIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getGauntletEntry().get()}), new ICondition[]{enableGauntlets, isSingleAddition}, triggerInstance, "");
                    } else {
                        GauntletItemBuilder.conditionalSmithingWithoutTemplateRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, craftingIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getGauntletEntry().get()}), new ICondition[]{enableGauntlets, isSingleAddition}, triggerInstance, "");
                    }
                }
            }
        });
    }

    public record TrimModelData(String name, float itemModelIndex, Map<String, String> overrideMaterials) {
        public String name(@Nullable Material p_268105_) {
            if (p_268105_ != null) {
                return this.overrideMaterials.getOrDefault(p_268105_.getName(), this.name);
            }
            return this.name;
        }
    }
}

