/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.registry.itemGeneration;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.userofbricks.expanded_combat.api.NonNullTriConsumer;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.MaterialBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.MaterialItemBuilder;
import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECConfigBooleanCondition;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECMaterialBooleanCondition;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrossBowItemBuilder
extends MaterialItemBuilder {
    public final MaterialBuilder materialBuilder;
    public final Material material;
    public final Material craftedFrom;
    public final ItemBuilder<? extends CrossbowItem, Registrate> itemBuilder;
    private String lang = "";
    private NonNullTriConsumer<ItemBuilder<? extends CrossbowItem, Registrate>, Material, Boolean> modelBuilder;
    private NonNullTriConsumer<ItemBuilder<? extends CrossbowItem, Registrate>, Material, @Nullable Material> recipeBuilder;
    private NonNullConsumer<ItemBuilder<? extends CrossbowItem, Registrate>> colorBuilder;

    public CrossBowItemBuilder(MaterialBuilder materialBuilder, Registrate registrate, Material material, Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends CrossbowItem> constructor) {
        ItemBuilder itemBuilder = registrate.item(material.getLocationName().m_135815_() + "_crossbow", p -> (CrossbowItem)constructor.apply(p, (Object)material));
        itemBuilder.properties(properties -> properties.m_41487_(1));
        itemBuilder.tag(new TagKey[]{ECItemTags.CROSSBOWS});
        this.material = material;
        this.itemBuilder = itemBuilder;
        this.materialBuilder = materialBuilder;
        this.craftedFrom = craftedFrom;
        this.lang = material.getName() + " Crossbow";
        this.modelBuilder = CrossBowItemBuilder::generateModel;
        this.recipeBuilder = CrossBowItemBuilder::generateRecipes;
        this.colorBuilder = CrossBowItemBuilder::colors;
    }

    public CrossBowItemBuilder lang(String englishName) {
        this.lang = englishName;
        return this;
    }

    public CrossBowItemBuilder model(NonNullTriConsumer<ItemBuilder<? extends CrossbowItem, Registrate>, Material, Boolean> modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public CrossBowItemBuilder recipes(NonNullTriConsumer<ItemBuilder<? extends CrossbowItem, Registrate>, Material, Material> recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public CrossBowItemBuilder color(NonNullConsumer<ItemBuilder<? extends CrossbowItem, Registrate>> colorBuilder) {
        this.colorBuilder = colorBuilder;
        return this;
    }

    public MaterialBuilder build(boolean dyeable) {
        this.itemBuilder.lang(this.lang);
        this.modelBuilder.apply(this.itemBuilder, this.material, dyeable);
        this.recipeBuilder.apply(this.itemBuilder, this.material, this.craftedFrom);
        if (dyeable) {
            this.colorBuilder.accept(this.itemBuilder);
        }
        this.materialBuilder.crossBow((NonNullFunction<Material, RegistryEntry<? extends CrossbowItem>>)((NonNullFunction)m -> this.itemBuilder.register()));
        return this.materialBuilder;
    }

    public static void colors(ItemBuilder<? extends CrossbowItem, Registrate> itemBuilder) {
        itemBuilder.color(() -> () -> (stack, itemLayer) -> itemLayer == 0 ? ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack) : -1);
    }

    public static void generateModel(ItemBuilder<? extends CrossbowItem, Registrate> itemBuilder, Material material, boolean dyeable) {
        String locationName = material.getLocationName().m_135815_();
        itemBuilder.model((ctx, prov) -> ((ItemModelBuilder)prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{new ResourceLocation(material.getLocationName().m_135827_(), "item/crossbow/" + locationName)}).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-90.0f, 0.0f, -60.0f).translation(2.0f, 0.1f, -3.0f).scale(0.9f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-90.0f, 0.0f, 30.0f).translation(2.0f, 0.1f, -3.0f).scale(0.9f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-90.0f, 0.0f, -55.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-90.0f, 0.0f, 35.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().end()).override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_0", new ResourceLocation("item/crossbow"))).texture("layer0", new ResourceLocation(material.getLocationName().m_135827_(), "item/crossbow/" + locationName + "_pulling_0"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.58f).model((ModelFile)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_1", new ResourceLocation("item/crossbow"))).texture("layer0", new ResourceLocation(material.getLocationName().m_135827_(), "item/crossbow/" + locationName + "_pulling_1"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 1.0f).model((ModelFile)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_2", new ResourceLocation("item/crossbow"))).texture("layer0", new ResourceLocation(material.getLocationName().m_135827_(), "item/crossbow/" + locationName + "_pulling_2"))).end().override().predicate(new ResourceLocation("charged"), 1.0f).model((ModelFile)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_arrow", new ResourceLocation("item/crossbow"))).texture("layer0", new ResourceLocation(material.getLocationName().m_135827_(), "item/crossbow/" + locationName + "_arrow"))).end().override().predicate(new ResourceLocation("charged"), 1.0f).predicate(new ResourceLocation("firework"), 1.0f).model((ModelFile)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_firework", new ResourceLocation("item/crossbow"))).texture("layer0", new ResourceLocation(material.getLocationName().m_135827_(), "item/crossbow/" + locationName + "_firework"))).end());
    }

    public static void generateRecipes(ItemBuilder<? extends CrossbowItem, Registrate> itemBuilder, Material material, @Nullable Material craftedFrom) {
        String name = material.getName();
        itemBuilder.recipe((ctx, prov) -> {
            boolean useCraftingItem;
            Ingredient craftingIngredient = null;
            InventoryChangeTrigger.TriggerInstance triggerInstance = null;
            boolean bl = useCraftingItem = !material.getConfig().crafting.craftingItem.isEmpty();
            if (useCraftingItem) {
                craftingIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem))});
                triggerInstance = CrossBowItemBuilder.getTriggerInstance((ArrayList)Collections.singletonList(material.getConfig().crafting.craftingItem));
            } else if (!material.getConfig().crafting.repairItem.isEmpty()) {
                craftingIngredient = IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
                triggerInstance = CrossBowItemBuilder.getTriggerInstance(material.getConfig().crafting.repairItem);
            }
            if (craftingIngredient != null) {
                ECConfigBooleanCondition enableCrossBows = new ECConfigBooleanCondition("crossbow");
                ECMaterialBooleanCondition isSingleAddition = new ECMaterialBooleanCondition(name, "config", "crafting", "is_single_addition");
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                ingredientMap.put(Character.valueOf('i'), craftingIngredient);
                ingredientMap.put(Character.valueOf('b'), craftedFrom == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42717_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getCrossbowEntry().get()}));
                CrossBowItemBuilder.conditionalShapedRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, new String[]{"ibi", " i "}, ingredientMap, 1, new ICondition[]{enableCrossBows, new NotCondition((ICondition)isSingleAddition)}, triggerInstance, "");
                CrossBowItemBuilder.conditionalSmithing120Recipe((DataGenContext<Item, ? extends Item>)ctx, prov, material, craftedFrom == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42717_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getCrossbowEntry().get()}), new ICondition[]{enableCrossBows, isSingleAddition}, "");
            }
        });
    }
}

