/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.registry.itemGeneration;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.userofbricks.expanded_combat.api.NonNullTriConsumer;
import com.userofbricks.expanded_combat.api.NonNullTriFunction;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.MaterialBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.MaterialItemBuilder;
import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECConfigBooleanCondition;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECMaterialBooleanCondition;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BowItemBuilder
extends MaterialItemBuilder {
    public final MaterialBuilder materialBuilder;
    public final Material material;
    public final Material craftedFrom;
    public final ItemBuilder<? extends BowItem, Registrate> itemBuilder;
    public final ItemBuilder<? extends BowItem, Registrate> halfItemBuilder;
    private String lang = "";
    private NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, Boolean> modelBuilder;
    private NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, Boolean> halfModelBuilder;
    private NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, @Nullable Material> recipeBuilder;
    private NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, @Nullable Material> halfRecipeBuilder;
    private NonNullConsumer<ItemBuilder<? extends BowItem, Registrate>> colorBuilder;
    private NonNullConsumer<ItemBuilder<? extends BowItem, Registrate>> halfColorBuilder;

    public BowItemBuilder(MaterialBuilder materialBuilder, Registrate registrate, Material material, Material craftedFrom, NonNullTriFunction<Item.Properties, Material, Material, ? extends BowItem> constructor) {
        ItemBuilder itemBuilder = registrate.item(material.getLocationName().m_135815_() + "_bow", p -> (BowItem)constructor.apply((Item.Properties)p, material, craftedFrom));
        itemBuilder.properties(properties -> properties.m_41487_(1));
        itemBuilder.tag(new TagKey[]{ECItemTags.BOWS});
        this.material = material;
        this.itemBuilder = itemBuilder;
        this.halfItemBuilder = null;
        this.materialBuilder = materialBuilder;
        this.craftedFrom = craftedFrom;
        this.lang = material.getName() + " Bow";
        this.modelBuilder = (registrateItemBuilder, material1, aBoolean) -> BowItemBuilder.genModel((ItemBuilder<? extends BowItem, Registrate>)itemBuilder, material.getLocationName().m_135815_(), "", aBoolean);
        this.recipeBuilder = BowItemBuilder::generateRecipes;
        this.colorBuilder = BowItemBuilder::colors;
    }

    public BowItemBuilder(MaterialBuilder materialBuilder, Registrate registrate, Material material, Material craftedFrom, NonNullTriFunction<Item.Properties, Material, Material, ? extends BowItem> constructor, NonNullTriFunction<Item.Properties, Material, Material, ? extends BowItem> halfConstructor) {
        ItemBuilder itemBuilder = registrate.item(material.getLocationName().m_135815_() + "_bow", p -> (BowItem)constructor.apply((Item.Properties)p, material, craftedFrom));
        ItemBuilder halfItemBuilder = registrate.item("half_" + material.getLocationName().m_135815_() + "_bow", p -> (BowItem)halfConstructor.apply((Item.Properties)p, material, craftedFrom));
        itemBuilder.properties(properties -> properties.m_41487_(1));
        halfItemBuilder.properties(properties -> properties.m_41487_(1));
        itemBuilder.tag(new TagKey[]{ECItemTags.BOWS});
        halfItemBuilder.tag(new TagKey[]{ECItemTags.BOWS});
        this.material = material;
        this.itemBuilder = itemBuilder;
        this.halfItemBuilder = halfItemBuilder;
        this.materialBuilder = materialBuilder;
        this.craftedFrom = craftedFrom;
        this.lang = material.getName() + " Bow";
        this.modelBuilder = (registrateItemBuilder, material1, aBoolean) -> BowItemBuilder.genModel((ItemBuilder<? extends BowItem, Registrate>)itemBuilder, material.getLocationName().m_135815_(), "", aBoolean);
        this.recipeBuilder = BowItemBuilder::generateRecipes;
        this.colorBuilder = BowItemBuilder::colors;
        this.halfModelBuilder = (registrateItemBuilder, material1, aBoolean) -> BowItemBuilder.genModel((ItemBuilder<? extends BowItem, Registrate>)halfItemBuilder, material.getLocationName().m_135815_(), "half_", aBoolean);
        this.halfRecipeBuilder = BowItemBuilder::generateHalfRecipes;
        this.halfColorBuilder = BowItemBuilder::colors;
    }

    public BowItemBuilder lang(String englishName) {
        this.lang = englishName;
        return this;
    }

    public BowItemBuilder model(NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, Boolean> modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public BowItemBuilder recipes(NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, Material> recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public BowItemBuilder color(NonNullConsumer<ItemBuilder<? extends BowItem, Registrate>> colorBuilder) {
        this.colorBuilder = colorBuilder;
        return this;
    }

    public BowItemBuilder halfModel(NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, Boolean> modelBuilder) {
        this.halfModelBuilder = modelBuilder;
        return this;
    }

    public BowItemBuilder halfRecipes(NonNullTriConsumer<ItemBuilder<? extends BowItem, Registrate>, Material, Material> recipeBuilder) {
        this.halfRecipeBuilder = recipeBuilder;
        return this;
    }

    public BowItemBuilder halfColor(NonNullConsumer<ItemBuilder<? extends BowItem, Registrate>> colorBuilder) {
        this.halfColorBuilder = colorBuilder;
        return this;
    }

    public MaterialBuilder build(boolean dyeable) {
        if (this.halfItemBuilder != null) {
            this.halfItemBuilder.lang(this.lang);
            this.halfModelBuilder.apply(this.halfItemBuilder, this.material, dyeable);
            this.halfRecipeBuilder.apply(this.halfItemBuilder, this.material, this.craftedFrom);
            if (dyeable) {
                this.halfColorBuilder.accept(this.halfItemBuilder);
            }
            this.materialBuilder.halfbow((NonNullFunction<Material, RegistryEntry<? extends BowItem>>)((NonNullFunction)m -> this.halfItemBuilder.register()));
        }
        this.itemBuilder.lang(this.lang);
        this.modelBuilder.apply(this.itemBuilder, this.material, dyeable);
        this.recipeBuilder.apply(this.itemBuilder, this.material, this.craftedFrom);
        if (dyeable) {
            this.colorBuilder.accept(this.itemBuilder);
        }
        this.materialBuilder.bow((NonNullFunction<Material, RegistryEntry<? extends BowItem>>)((NonNullFunction)m -> this.itemBuilder.register()));
        return this.materialBuilder;
    }

    public static void colors(ItemBuilder<? extends Item, Registrate> itemBuilder) {
        itemBuilder.color(() -> () -> (stack, itemLayer) -> itemLayer == 0 ? ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack) : -1);
    }

    public static void generateRecipes(ItemBuilder<? extends BowItem, Registrate> itemBuilder, Material material, @Nullable Material craftedFrom) {
        itemBuilder.recipe((ctx, prov) -> {
            boolean useCraftingItem;
            Ingredient craftingIngredient = null;
            InventoryChangeTrigger.TriggerInstance triggerInstance = null;
            boolean bl = useCraftingItem = !material.getConfig().crafting.craftingItem.isEmpty();
            if (useCraftingItem) {
                craftingIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem))});
                triggerInstance = BowItemBuilder.getTriggerInstance((ArrayList)Collections.singletonList(material.getConfig().crafting.craftingItem));
            } else if (!material.getConfig().crafting.repairItem.isEmpty()) {
                craftingIngredient = IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
                triggerInstance = BowItemBuilder.getTriggerInstance(material.getConfig().crafting.repairItem);
            }
            if (craftingIngredient != null) {
                ECConfigBooleanCondition enableBows = new ECConfigBooleanCondition("bow");
                ECConfigBooleanCondition enableHalfBows = new ECConfigBooleanCondition("half_bow");
                ECMaterialBooleanCondition isSingleAddition = new ECMaterialBooleanCondition(material.getName(), "config", "crafting", "is_single_addition");
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                ingredientMap.put(Character.valueOf('i'), craftingIngredient);
                if (material.halfbow) {
                    ingredientMap.put(Character.valueOf('b'), material.getHalfBowEntry() == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42411_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)material.getHalfBowEntry().get()}));
                    BowItemBuilder.conditionalShapedRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, new String[]{"i", "b"}, ingredientMap, 1, new ICondition[]{enableBows, enableHalfBows}, triggerInstance, "");
                }
                ingredientMap.remove(Character.valueOf('b'));
                ingredientMap.put(Character.valueOf('b'), craftedFrom == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42411_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getBowEntry().get()}));
                BowItemBuilder.conditionalShapedRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, new String[]{"i", "b", "i"}, ingredientMap, 1, new ICondition[]{enableBows}, triggerInstance, "_skip");
                BowItemBuilder.conditionalSmithing120Recipe((DataGenContext<Item, ? extends Item>)ctx, prov, material, material.getHalfBowEntry() == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42411_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)material.getHalfBowEntry().get()}), new ICondition[]{enableBows, enableHalfBows, new NotCondition((ICondition)isSingleAddition)}, "");
                BowItemBuilder.conditionalSmithing120Recipe((DataGenContext<Item, ? extends Item>)ctx, prov, material, craftedFrom == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42411_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getBowEntry().get()}), new ICondition[]{enableBows, new OrCondition(new ICondition[]{new NotCondition((ICondition)enableHalfBows), isSingleAddition})}, "_singleton");
            }
        });
    }

    public static void generateHalfRecipes(ItemBuilder<? extends BowItem, Registrate> itemBuilder, Material material, @Nullable Material craftedFrom) {
        itemBuilder.recipe((ctx, prov) -> {
            boolean useCraftingItem;
            Ingredient craftingIngredient = null;
            InventoryChangeTrigger.TriggerInstance triggerInstance = null;
            boolean bl = useCraftingItem = !material.getConfig().crafting.craftingItem.isEmpty();
            if (useCraftingItem) {
                craftingIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem))});
                triggerInstance = BowItemBuilder.getTriggerInstance((ArrayList)Collections.singletonList(material.getConfig().crafting.craftingItem));
            } else if (!material.getConfig().crafting.repairItem.isEmpty()) {
                craftingIngredient = IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
                triggerInstance = BowItemBuilder.getTriggerInstance(material.getConfig().crafting.repairItem);
            }
            if (craftingIngredient != null) {
                ECConfigBooleanCondition enableBows = new ECConfigBooleanCondition("bow");
                ECConfigBooleanCondition enableHalfBows = new ECConfigBooleanCondition("half_bow");
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                ingredientMap.put(Character.valueOf('i'), craftingIngredient);
                ingredientMap.put(Character.valueOf('b'), material.getHalfBowEntry() == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42411_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)material.getHalfBowEntry().get()}));
                BowItemBuilder.conditionalShapedRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, new String[]{"b", "i"}, ingredientMap, 1, new ICondition[]{enableBows, enableHalfBows}, triggerInstance, "");
                BowItemBuilder.conditionalSmithing120Recipe((DataGenContext<Item, ? extends Item>)ctx, prov, material, craftedFrom == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42411_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getBowEntry().get()}), new ICondition[]{enableBows, enableHalfBows}, "");
            }
        });
    }

    private static void genModel(ItemBuilder<? extends BowItem, Registrate> itemBuilder, String locationName, String prefix, boolean dyeable) {
        String modid = ((Registrate)itemBuilder.getParent()).getModid();
        itemBuilder.model((ctx, prov) -> {
            ItemModelBuilder itemModelBuilder = dyeable ? prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{new ResourceLocation(modid, "item/bow/" + prefix + locationName), new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_overlay")}) : prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{new ResourceLocation(modid, "item/bow/" + prefix + locationName)});
            ((ItemModelBuilder)itemModelBuilder.transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-80.0f, 260.0f, -40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-80.0f, -280.0f, 40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().end()).override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)(!dyeable ? ((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_0", new ResourceLocation("item/bow"))).texture("layer0", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_0")) : ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_0", new ResourceLocation("item/bow"))).texture("layer0", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_0"))).texture("layer1", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_0_overlay")))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.65f).model((ModelFile)(!dyeable ? ((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_1", new ResourceLocation("item/bow"))).texture("layer0", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_1")) : ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_1", new ResourceLocation("item/bow"))).texture("layer0", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_1"))).texture("layer1", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_1_overlay")))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.9f).model((ModelFile)(!dyeable ? ((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_2", new ResourceLocation("item/bow"))).texture("layer0", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_2")) : ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName() + "_pulling_2", new ResourceLocation("item/bow"))).texture("layer0", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_2"))).texture("layer1", new ResourceLocation(modid, "item/bow/" + prefix + locationName + "_pulling_2_overlay")))).end();
        });
    }
}

