/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.registry.itemGeneration;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.userofbricks.expanded_combat.api.NonNullTriConsumer;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.MaterialBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.MaterialItemBuilder;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECConfigBooleanCondition;
import com.userofbricks.expanded_combat.item.recipes.conditions.ECMaterialBooleanCondition;
import com.userofbricks.expanded_combat.util.IngredientUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ArrowItemBuilder
extends MaterialItemBuilder {
    public final MaterialBuilder materialBuilder;
    public final Material material;
    public final Material craftedFrom;
    public final ItemBuilder<? extends ArrowItem, Registrate> itemBuilder;
    public final ItemBuilder<? extends ArrowItem, Registrate> tippedBuilder;
    private String lang = "";
    private NonNullBiConsumer<ItemBuilder<? extends ArrowItem, Registrate>, Material> modelBuilder;
    private NonNullBiConsumer<ItemBuilder<? extends ArrowItem, Registrate>, Material> tippedModelBuilder;
    private NonNullTriConsumer<ItemBuilder<? extends ArrowItem, Registrate>, Material, @Nullable Material> recipeBuilder;

    public ArrowItemBuilder(MaterialBuilder materialBuilder, Registrate registrate, Material material, Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem> constructor, NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem> tippedConstructor) {
        ItemBuilder itemBuilder = registrate.item(material.getLocationName().m_135815_() + "_arrow", p -> (ArrowItem)constructor.apply(p, (Object)material));
        if (tippedConstructor != null) {
            ItemBuilder tippedBuilder = registrate.item("tipped_" + material.getLocationName().m_135815_() + "_arrow", p -> (ArrowItem)tippedConstructor.apply(p, (Object)material));
            tippedBuilder.tag(new TagKey[]{ECItemTags.ARROWS, ItemTags.f_13161_});
            tippedBuilder.color(() -> () -> (itemStack, itemLayer) -> itemLayer == 1 ? PotionUtils.m_43575_((ItemStack)itemStack) : -1);
            this.tippedBuilder = tippedBuilder;
        } else {
            this.tippedBuilder = null;
        }
        itemBuilder.tag(new TagKey[]{ECItemTags.ARROWS, ItemTags.f_13161_});
        this.material = material;
        this.itemBuilder = itemBuilder;
        this.materialBuilder = materialBuilder;
        this.craftedFrom = craftedFrom;
        this.modelBuilder = ArrowItemBuilder::generateModel;
        this.tippedModelBuilder = ArrowItemBuilder::generateTippedModel;
        this.recipeBuilder = ArrowItemBuilder::generateRecipes;
    }

    public ArrowItemBuilder lang(String englishName) {
        this.lang = englishName;
        return this;
    }

    public ArrowItemBuilder model(NonNullBiConsumer<ItemBuilder<? extends ArrowItem, Registrate>, Material> modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public ArrowItemBuilder tippedModel(NonNullBiConsumer<ItemBuilder<? extends ArrowItem, Registrate>, Material> modelBuilder) {
        this.tippedModelBuilder = modelBuilder;
        return this;
    }

    public ArrowItemBuilder recipes(NonNullTriConsumer<ItemBuilder<? extends ArrowItem, Registrate>, Material, Material> recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public MaterialBuilder build() {
        if (!this.lang.isBlank()) {
            this.itemBuilder.lang(this.lang);
            if (this.tippedBuilder != null) {
                this.tippedBuilder.lang(this.lang);
            }
        }
        this.modelBuilder.accept(this.itemBuilder, (Object)this.material);
        if (this.tippedBuilder != null) {
            this.tippedModelBuilder.accept(this.tippedBuilder, (Object)this.material);
        }
        this.recipeBuilder.apply(this.itemBuilder, this.material, this.craftedFrom);
        this.materialBuilder.arrow((NonNullFunction<Material, RegistryEntry<? extends ArrowItem>>)((NonNullFunction)m -> this.itemBuilder.register()));
        if (this.tippedBuilder != null) {
            this.materialBuilder.tippedArrow((NonNullFunction<Material, RegistryEntry<? extends ArrowItem>>)((NonNullFunction)m -> this.tippedBuilder.register()));
        }
        return this.materialBuilder;
    }

    private static void generateTippedModel(ItemBuilder<? extends ArrowItem, Registrate> itemBuilder, Material material) {
        itemBuilder.model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{material.getLocationName().m_246208_("item/arrow/"), new ResourceLocation("expanded_combat", "item/arrow/tipped_head")}));
    }

    private static void generateModel(ItemBuilder<? extends ArrowItem, Registrate> itemBuilder, Material material) {
        itemBuilder.model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{material.getLocationName().m_246208_("item/arrow/")}));
    }

    public static void generateRecipes(ItemBuilder<? extends ArrowItem, Registrate> itemBuilder, Material material, Material craftedFrom) {
        String name = material.getName();
        itemBuilder.recipe((ctx, prov) -> {
            boolean useCraftingItem;
            Ingredient craftingIngredient = null;
            InventoryChangeTrigger.TriggerInstance triggerInstance = null;
            boolean bl = useCraftingItem = !material.getConfig().crafting.craftingItem.isEmpty();
            if (useCraftingItem) {
                craftingIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.craftingItem))});
                triggerInstance = ArrowItemBuilder.getTriggerInstance((ArrayList)Collections.singletonList(material.getConfig().crafting.craftingItem));
            } else if (!material.getConfig().crafting.repairItem.isEmpty()) {
                craftingIngredient = IngredientUtil.getIngrediantFromItemString(material.getConfig().crafting.repairItem);
                triggerInstance = ArrowItemBuilder.getTriggerInstance(material.getConfig().crafting.repairItem);
            }
            if (craftingIngredient != null) {
                ECConfigBooleanCondition enableArrows = new ECConfigBooleanCondition("arrow");
                ECMaterialBooleanCondition isSingleAddition = new ECMaterialBooleanCondition(name, "config", "crafting", "is_single_addition");
                HashMap<Character, Ingredient> recipe = new HashMap<Character, Ingredient>();
                recipe.put(Character.valueOf('X'), craftingIngredient);
                recipe.put(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}));
                recipe.put(Character.valueOf('Y'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42402_}));
                ArrowItemBuilder.conditionalShapedRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, new String[]{"X", "#", "Y"}, recipe, 4, new ICondition[]{enableArrows, new NotCondition((ICondition)isSingleAddition)}, triggerInstance, "");
                if (material.getConfig().crafting.smithingTemplate != null && !Objects.equals(material.getConfig().crafting.smithingTemplate, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)Items.f_41852_)).toString())) {
                    ArrowItemBuilder.conditionalSmithing120Recipe((DataGenContext<Item, ? extends Item>)ctx, prov, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(material.getConfig().crafting.smithingTemplate))}), craftingIngredient, craftedFrom == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42412_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getArrowEntry().get()}), new ICondition[]{enableArrows, isSingleAddition}, triggerInstance, "");
                } else {
                    ArrowItemBuilder.conditionalSmithingWithoutTemplateRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, craftingIngredient, craftedFrom == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42412_}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)craftedFrom.getArrowEntry().get()}), new ICondition[]{enableArrows, isSingleAddition}, triggerInstance, "");
                }
                InventoryChangeTrigger.TriggerInstance fletchingTriggerInstance = InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ECItems.FLETCHED_STICKS.get()});
                ArrowItemBuilder.conditionalFletchingRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, craftingIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ECItems.FLETCHED_STICKS.get()}), new ICondition[]{enableArrows, new NotCondition((ICondition)isSingleAddition)}, fletchingTriggerInstance, "", 6);
                ArrowItemBuilder.conditionalVariableFletchingRecipe((DataGenContext<Item, ? extends Item>)ctx, prov, craftingIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{craftedFrom != null ? (ItemLike)craftedFrom.getArrowEntry().get() : Items.f_42412_}), new ICondition[]{enableArrows, isSingleAddition}, fletchingTriggerInstance, "", 32);
            }
        });
    }
}

