/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.registry;

import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.MaterialBuilder;
import com.userofbricks.expanded_combat.api.material.WeaponMaterial;
import com.userofbricks.expanded_combat.api.registry.ShieldMaterialUseTick;
import com.userofbricks.expanded_combat.api.registry.ShieldToMaterials;
import com.userofbricks.expanded_combat.init.MaterialInit;
import org.jetbrains.annotations.ApiStatus;

public class RegistrationHandler {
    public Material registerMaterial(MaterialBuilder builder) {
        return builder.build();
    }

    @ApiStatus.Internal
    public WeaponMaterial registerWeaponMaterial(WeaponMaterial.Builder builder) {
        for (WeaponMaterial material : MaterialInit.weaponMaterialConfigs) {
            if (!material.name().equals(builder.name())) continue;
            throw new IllegalArgumentException(String.format("Duplicate Expanded Combat Weapon Material: %s", builder.name()));
        }
        return builder.build();
    }

    public static class ShieldMaterialRegisterator {
        public ShieldToMaterials registerShieldToMaterials(ShieldToMaterials shieldToMaterials) {
            MaterialInit.shieldToMaterialsList.add(shieldToMaterials);
            return shieldToMaterials;
        }

        public ShieldMaterialUseTick registerShieldMaterialUseTick(ShieldMaterialUseTick shieldToMaterials) {
            MaterialInit.shieldMaterialUseTickList.add(shieldToMaterials);
            return shieldToMaterials;
        }
    }
}

