/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.material;

import com.userofbricks.expanded_combat.config.WeaponMaterialConfig;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.recipes.builders.RecipeIngredientMapBuilder;
import java.util.Locale;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record WeaponMaterial(@NotNull String name, @Nullable WeaponMaterial craftedFrom, @NotNull WeaponMaterialConfig config, boolean potionDippable, boolean dyeable, boolean isBlockWeapon, boolean hasCustomTransforms, boolean hasLargeModel, Supplier<RecipeIngredientMapBuilder> recipeIngredients, String[] recipe) {
    public WeaponMaterial(@NotNull String name, @Nullable WeaponMaterial craftedFrom, @NotNull WeaponMaterialConfig config, boolean potionDippable, boolean dyeable, boolean isBlockWeapon, boolean hasCustomTransforms, boolean hasLargeModel, Supplier<RecipeIngredientMapBuilder> recipeIngredients, String[] recipe) {
        MaterialInit.weaponMaterialConfigs.add(this);
        this.name = name;
        this.craftedFrom = craftedFrom;
        this.config = config;
        this.potionDippable = potionDippable;
        this.dyeable = dyeable;
        this.isBlockWeapon = isBlockWeapon;
        this.hasCustomTransforms = hasCustomTransforms;
        this.hasLargeModel = hasLargeModel;
        this.recipeIngredients = recipeIngredients;
        this.recipe = recipe;
    }

    public String getLocationName() {
        return this.name.toLowerCase(Locale.ROOT).replace(' ', '_').replace('\'', '_');
    }

    public boolean recipeContains(String character) {
        for (String row : this.recipe) {
            if (!row.contains(character)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final String name;
        private WeaponMaterial craftedFrom = null;
        private final WeaponMaterialConfig config;
        private boolean potionDippable = false;
        private boolean dyeable = false;
        private boolean isBlockWeapon = false;
        private boolean hasCustomTransforms = false;
        private boolean hasLargeModel = false;
        private final Supplier<RecipeIngredientMapBuilder> recipeIngredients;
        private final String[] recipe;

        public Builder(String name, WeaponMaterialConfig config, Supplier<RecipeIngredientMapBuilder> recipeIngredients, String[] recipe) {
            this.name = name;
            this.config = config;
            this.recipeIngredients = recipeIngredients;
            this.recipe = recipe;
        }

        public Builder potionDippable() {
            this.potionDippable = true;
            return this;
        }

        public Builder dyeable() {
            this.dyeable = true;
            return this;
        }

        public Builder blockWeapon() {
            this.isBlockWeapon = true;
            return this;
        }

        public Builder hasLargeModel() {
            this.hasLargeModel = true;
            return this;
        }

        public Builder craftedFrom(WeaponMaterial material) {
            this.craftedFrom = material;
            return this;
        }

        public Builder customModelTransforms() {
            this.hasCustomTransforms = true;
            return this;
        }

        public WeaponMaterial build() {
            return new WeaponMaterial(this.name, this.craftedFrom, this.config, this.potionDippable, this.dyeable, this.isBlockWeapon, this.hasCustomTransforms, this.hasLargeModel, this.recipeIngredients, this.recipe);
        }

        public String name() {
            return this.name;
        }
    }
}

