/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.material;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.userofbricks.expanded_combat.api.NonNullTriFunction;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.material.WeaponMaterial;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.ArrowItemBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.BowItemBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.CrossBowItemBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.GauntletItemBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.MultiWeaponBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.QuiverItemBuilder;
import com.userofbricks.expanded_combat.api.registry.itemGeneration.WeaponItemBuilder;
import com.userofbricks.expanded_combat.config.MaterialConfig;
import com.userofbricks.expanded_combat.init.LangStrings;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.item.ECArrowItem;
import com.userofbricks.expanded_combat.item.ECBowItem;
import com.userofbricks.expanded_combat.item.ECCrossBowItem;
import com.userofbricks.expanded_combat.item.ECGauntletItem;
import com.userofbricks.expanded_combat.item.ECHammerWeaponItem;
import com.userofbricks.expanded_combat.item.ECKatanaItem;
import com.userofbricks.expanded_combat.item.ECQuiverItem;
import com.userofbricks.expanded_combat.item.ECTippedArrowItem;
import com.userofbricks.expanded_combat.item.ECWeaponItem;
import com.userofbricks.expanded_combat.plugins.VanillaECPlugin;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialBuilder {
    @NotNull
    private final NonNullSupplier<Registrate> registrate;
    @NotNull
    private final Material material;
    @NotNull
    public final ResourceLocation id;

    public MaterialBuilder(@NotNull NonNullSupplier<Registrate> registrate, @NotNull String name, @NotNull MaterialConfig config) {
        this(registrate, name, (NonNullSupplier<MaterialConfig>)((NonNullSupplier)() -> config));
    }

    public MaterialBuilder(@NotNull NonNullSupplier<Registrate> registrate, @NotNull String name, @NotNull NonNullSupplier<MaterialConfig> config) {
        this.registrate = registrate;
        this.id = new ResourceLocation(((Registrate)registrate.get()).getModid(), LangStrings.getLocationPathVersion(name));
        this.material = new Material(name, this.id, config);
    }

    public MaterialBuilder alias(String shieldPart, String ... name) {
        assert (this.material.aliases != null);
        this.material.aliases.put(shieldPart, List.of(name));
        return this;
    }

    public MaterialBuilder bow(@Nullable Material craftedFrom, boolean halfToo, boolean dyeable) {
        return this.bow(craftedFrom, ECBowItem::new, halfToo).build(dyeable);
    }

    public MaterialBuilder bow(@Nullable Material craftedFrom, boolean halfToo) {
        return this.bow(craftedFrom, ECBowItem::new, halfToo).build(false);
    }

    public MaterialBuilder bowAndHalfBow(@Nullable Material craftedFrom) {
        return this.bow(craftedFrom, ECBowItem::new, true).build(false);
    }

    public MaterialBuilder bowAndHalfBow() {
        return this.bow(null, ECBowItem::new, true).build(false);
    }

    public BowItemBuilder bow(@Nullable Material craftedFrom, NonNullTriFunction<Item.Properties, Material, Material, ? extends BowItem> bowConstructor, boolean halfToo) {
        return halfToo ? new BowItemBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, bowConstructor, bowConstructor) : new BowItemBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, bowConstructor);
    }

    public BowItemBuilder bowWithHalfBow(@Nullable Material craftedFrom, NonNullTriFunction<Item.Properties, Material, Material, ? extends BowItem> bowConstructor, NonNullTriFunction<Item.Properties, Material, Material, ? extends BowItem> halfBowConstructor) {
        return new BowItemBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, bowConstructor, halfBowConstructor);
    }

    public MaterialBuilder bow(NonNullFunction<Material, RegistryEntry<? extends BowItem>> bowEntryFunction) {
        if (!MaterialInit.bowMaterials.contains(this.material)) {
            MaterialInit.bowMaterials.add(this.material);
        }
        this.material.bowEntry = (RegistryEntry)bowEntryFunction.apply((Object)this.material);
        return this;
    }

    public MaterialBuilder halfbow(NonNullFunction<Material, RegistryEntry<? extends BowItem>> bowEntryFunction) {
        if (!MaterialInit.bowMaterials.contains(this.material)) {
            MaterialInit.bowMaterials.add(this.material);
        }
        this.material.halfbow = true;
        this.material.halfBowEntry = (RegistryEntry)bowEntryFunction.apply((Object)this.material);
        return this;
    }

    public MaterialBuilder arrow(@Nullable Material craftedFrom, boolean tipped) {
        if (tipped) {
            return this.arrow(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem>)((NonNullBiFunction)ECArrowItem::new), (NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem>)((NonNullBiFunction)ECTippedArrowItem::new)).build();
        }
        return this.arrow(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem>)((NonNullBiFunction)ECArrowItem::new));
    }

    public MaterialBuilder arrow() {
        return this.arrow(null, true);
    }

    public MaterialBuilder arrow(@Nullable Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem> arrowConstructor) {
        return this.arrow(craftedFrom, arrowConstructor, null).build();
    }

    public ArrowItemBuilder arrow(@Nullable Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem> arrowConstructor, @Nullable NonNullBiFunction<Item.Properties, Material, ? extends ArrowItem> tippedArrowConstructor) {
        return new ArrowItemBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, arrowConstructor, tippedArrowConstructor);
    }

    public MaterialBuilder arrow(NonNullFunction<Material, RegistryEntry<? extends ArrowItem>> arrowEntryFunction) {
        if (!MaterialInit.arrowMaterials.contains(this.material)) {
            MaterialInit.arrowMaterials.add(this.material);
        }
        this.material.arrowEntry = (RegistryEntry)arrowEntryFunction.apply((Object)this.material);
        return this;
    }

    public MaterialBuilder tippedArrow(NonNullFunction<Material, RegistryEntry<? extends ArrowItem>> arrowEntryFunction) {
        if (!MaterialInit.arrowMaterials.contains(this.material)) {
            MaterialInit.arrowMaterials.add(this.material);
        }
        this.material.tippedArrowEntry = (RegistryEntry)arrowEntryFunction.apply((Object)this.material);
        return this;
    }

    public MaterialBuilder crossBow(@Nullable Material craftedFrom, boolean dyeable) {
        return this.crossBow(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends CrossbowItem>)((NonNullBiFunction)ECCrossBowItem::new)).build(dyeable);
    }

    public MaterialBuilder crossBow(@Nullable Material craftedFrom) {
        return this.crossBow(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends CrossbowItem>)((NonNullBiFunction)ECCrossBowItem::new)).build(false);
    }

    public MaterialBuilder crossBow() {
        return this.crossBow(null, (NonNullBiFunction<Item.Properties, Material, ? extends CrossbowItem>)((NonNullBiFunction)ECCrossBowItem::new)).build(false);
    }

    public CrossBowItemBuilder crossBow(@Nullable Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends CrossbowItem> crossBowConstructor) {
        return new CrossBowItemBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, crossBowConstructor);
    }

    public MaterialBuilder crossBow(NonNullFunction<Material, RegistryEntry<? extends CrossbowItem>> crossBowEntryFunction) {
        if (!MaterialInit.crossbowMaterials.contains(this.material)) {
            MaterialInit.crossbowMaterials.add(this.material);
        }
        this.material.crossbowEntry = (RegistryEntry)crossBowEntryFunction.apply((Object)this.material);
        return this;
    }

    public MaterialBuilder gauntlet(@Nullable Material craftedFrom) {
        return this.gauntlet(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends Item>)((NonNullBiFunction)ECGauntletItem::new)).build(false);
    }

    public MaterialBuilder gauntlet() {
        return this.gauntlet(null, (NonNullBiFunction<Item.Properties, Material, ? extends Item>)((NonNullBiFunction)ECGauntletItem::new)).build(false);
    }

    public MaterialBuilder dyeableGauntlet(@Nullable Material craftedFrom) {
        return this.gauntlet(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends Item>)((NonNullBiFunction)ECGauntletItem.Dyeable::new)).build(true);
    }

    public MaterialBuilder dyeableGauntlet() {
        return this.gauntlet(null, (NonNullBiFunction<Item.Properties, Material, ? extends Item>)((NonNullBiFunction)ECGauntletItem.Dyeable::new)).build(true);
    }

    public GauntletItemBuilder gauntlet(@Nullable Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends Item> constructor) {
        return new GauntletItemBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, constructor);
    }

    public MaterialBuilder gauntlet(NonNullFunction<Material, RegistryEntry<? extends Item>> constructor) {
        if (!MaterialInit.gauntletMaterials.contains(this.material)) {
            MaterialInit.gauntletMaterials.add(this.material);
        }
        this.material.gauntletEntry = (RegistryEntry)constructor.apply((Object)this.material);
        return this;
    }

    public MaterialBuilder quiver(@Nullable Material craftedFrom, boolean dyeable) {
        return this.quiver(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends Item>)((NonNullBiFunction)ECQuiverItem::new)).build(dyeable);
    }

    public MaterialBuilder quiver(@Nullable Material craftedFrom) {
        return this.quiver(craftedFrom, (NonNullBiFunction<Item.Properties, Material, ? extends Item>)((NonNullBiFunction)ECQuiverItem::new)).build(false);
    }

    public MaterialBuilder quiver() {
        return this.quiver(null, (NonNullBiFunction<Item.Properties, Material, ? extends Item>)((NonNullBiFunction)ECQuiverItem::new)).build(false);
    }

    public QuiverItemBuilder quiver(@Nullable Material craftedFrom, NonNullBiFunction<Item.Properties, Material, ? extends Item> constructor) {
        return new QuiverItemBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, constructor);
    }

    public MaterialBuilder quiver(NonNullFunction<Material, RegistryEntry<? extends Item>> constructor) {
        if (!MaterialInit.quiverMaterials.contains(this.material)) {
            MaterialInit.quiverMaterials.add(this.material);
        }
        this.material.quiverEntry = (RegistryEntry)constructor.apply((Object)this.material);
        return this;
    }

    public MaterialBuilder shield(Material.ShieldUse shieldUse, @Nullable Material craftedFrom) {
        if (!MaterialInit.shieldMaterials.contains(this.material)) {
            MaterialInit.shieldMaterials.add(this.material);
        }
        this.material.shieldUse = shieldUse;
        this.material.craftedFrom = craftedFrom;
        ((Registrate)this.registrate.get()).addRawLang("tooltip.expanded_combat.shield_material." + this.material.getName(), this.material.getName());
        return this;
    }

    public MaterialBuilder shield(@Nullable Material craftedFrom) {
        return this.shield(Material.ShieldUse.ALL, craftedFrom);
    }

    public MaterialBuilder shield() {
        return this.shield(Material.ShieldUse.ALL, null);
    }

    public MaterialBuilder greatHammer(@Nullable Material craftedFrom, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> constructor) {
        return this.weaponBuilder(VanillaECPlugin.GREAT_HAMMER, craftedFrom, constructor).build();
    }

    public MaterialBuilder katana(@Nullable Material craftedFrom, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> constructor) {
        return this.weaponBuilder(VanillaECPlugin.KATANA, craftedFrom, constructor).build();
    }

    public MaterialBuilder greatHammer(@Nullable Material craftedFrom) {
        return this.greatHammer(craftedFrom, (material1, weaponMaterial, properties) -> new ECHammerWeaponItem((Material)material1, (Item.Properties)properties));
    }

    public MaterialBuilder katana(@Nullable Material craftedFrom) {
        return this.katana(craftedFrom, (material1, weaponMaterial, properties) -> new ECKatanaItem((Material)material1, (Item.Properties)properties));
    }

    public MaterialBuilder blockWeapons(@Nullable Material craftedFrom, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> constructor, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> dyeableConstructor, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> hasPotionConstructor, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> greatHammerConstructor) {
        for (WeaponMaterial weaponMaterial : MaterialInit.weaponMaterialConfigs) {
            if (!weaponMaterial.isBlockWeapon()) continue;
            if (weaponMaterial == VanillaECPlugin.GREAT_HAMMER) {
                this.greatHammer(craftedFrom, greatHammerConstructor);
                continue;
            }
            if (weaponMaterial.dyeable()) {
                this.weaponBuilder(weaponMaterial, craftedFrom, dyeableConstructor).build();
                continue;
            }
            if (weaponMaterial.potionDippable()) {
                this.weaponBuilder(weaponMaterial, craftedFrom, hasPotionConstructor).build();
                continue;
            }
            this.weaponBuilder(weaponMaterial, craftedFrom, constructor).build();
        }
        return this;
    }

    public MaterialBuilder blockWeapons(@Nullable Material craftedFrom) {
        return this.blockWeapons(craftedFrom, ECWeaponItem::new, ECWeaponItem.Dyeable::new, ECWeaponItem.HasPotion::new, (material1, weaponMaterial, properties) -> new ECHammerWeaponItem((Material)material1, (Item.Properties)properties));
    }

    public MaterialBuilder weapons() {
        return this.weapons(null);
    }

    public MaterialBuilder weapons(@Nullable Material craftedFrom, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> constructor, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> dyeableConstructor, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> hasPotionConstructor, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> greatHammerConstructor, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> katanaConstructor) {
        for (WeaponMaterial weaponMaterial : MaterialInit.weaponMaterialConfigs) {
            if (weaponMaterial == VanillaECPlugin.KATANA) {
                this.katana(craftedFrom, katanaConstructor);
                continue;
            }
            if (weaponMaterial == VanillaECPlugin.GREAT_HAMMER) {
                this.greatHammer(craftedFrom, greatHammerConstructor);
                continue;
            }
            if (weaponMaterial.dyeable()) {
                this.weaponBuilder(weaponMaterial, craftedFrom, dyeableConstructor).build();
                continue;
            }
            if (weaponMaterial.potionDippable()) {
                this.weaponBuilder(weaponMaterial, craftedFrom, hasPotionConstructor).build();
                continue;
            }
            this.weaponBuilder(weaponMaterial, craftedFrom, constructor).build();
        }
        return this;
    }

    public MaterialBuilder weapons(@Nullable Material craftedFrom) {
        for (WeaponMaterial weaponMaterial : MaterialInit.weaponMaterialConfigs) {
            if (weaponMaterial == VanillaECPlugin.KATANA) {
                this.katana(craftedFrom);
                continue;
            }
            if (weaponMaterial == VanillaECPlugin.GREAT_HAMMER) {
                this.greatHammer(craftedFrom);
                continue;
            }
            if (weaponMaterial.dyeable()) {
                this.weaponBuilder(weaponMaterial, craftedFrom, ECWeaponItem.Dyeable::new).build();
                continue;
            }
            if (weaponMaterial.potionDippable()) {
                this.weaponBuilder(weaponMaterial, craftedFrom, ECWeaponItem.HasPotion::new).build();
                continue;
            }
            this.weaponBuilder(weaponMaterial, craftedFrom, ECWeaponItem::new).build();
        }
        return this;
    }

    public MultiWeaponBuilder multiWeaponBuilder(@Nullable Material craftedFrom) {
        return new MultiWeaponBuilder(this, (Registrate)this.registrate.get(), this.material, craftedFrom, !this.material.getConfig().crafting.isSingleAddition);
    }

    public WeaponItemBuilder weaponBuilder(WeaponMaterial weaponMaterial, @Nullable Material craftedFrom, NonNullTriFunction<Material, WeaponMaterial, Item.Properties, ? extends Item> constructor) {
        return new WeaponItemBuilder(this, (Registrate)this.registrate.get(), weaponMaterial, this.material, craftedFrom, constructor, !this.material.getConfig().crafting.isSingleAddition);
    }

    public MaterialBuilder weapon(WeaponMaterial weaponMaterial, NonNullFunction<Material, RegistryEntry<? extends Item>> constructor) {
        if (!MaterialInit.weaponMaterials.contains(this.material)) {
            MaterialInit.weaponMaterials.add(this.material);
        }
        this.material.weaponEntries.put(weaponMaterial.name(), (RegistryEntry<? extends Item>)((RegistryEntry)constructor.apply((Object)this.material)));
        return this;
    }

    public MaterialBuilder setAdditionalDamageAfterEnchantments(Function<Float, Float> additionalDamageAfterEnchantments) {
        this.material.additionalDamageAfterEnchantments = additionalDamageAfterEnchantments;
        return this;
    }

    public Material build() {
        return this.material;
    }
}

