/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat.api.material;

import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.userofbricks.expanded_combat.config.MaterialConfig;
import com.userofbricks.expanded_combat.init.MaterialInit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Material {
    @NotNull
    private final String name;
    @NotNull
    private final ResourceLocation id;
    public boolean halfbow;
    public Material craftedFrom;
    @Nullable
    protected Map<String, List<String>> aliases = new HashMap<String, List<String>>();
    public ShieldUse shieldUse = ShieldUse.ALL;
    @NotNull
    private final NonNullSupplier<MaterialConfig> config;
    protected Function<Float, Float> additionalDamageAfterEnchantments = damage -> Float.valueOf(0.0f);
    protected RegistryEntry<? extends ArrowItem> arrowEntry = null;
    protected RegistryEntry<? extends ArrowItem> tippedArrowEntry = null;
    protected RegistryEntry<? extends BowItem> bowEntry = null;
    protected RegistryEntry<? extends BowItem> halfBowEntry = null;
    protected RegistryEntry<? extends CrossbowItem> crossbowEntry = null;
    protected RegistryEntry<? extends Item> gauntletEntry = null;
    protected RegistryEntry<? extends Item> quiverEntry = null;
    protected final Map<String, RegistryEntry<? extends Item>> weaponEntries = new HashMap<String, RegistryEntry<? extends Item>>();

    public Material(@NotNull String name, @NotNull ResourceLocation id, @NotNull NonNullSupplier<MaterialConfig> config) {
        this.name = name;
        this.id = id;
        this.config = config;
        for (Material material : MaterialInit.materials) {
            if (!material.getLocationName().equals((Object)id)) continue;
            throw new IllegalArgumentException("Duplicate Expanded Combat Weapon Material: " + id);
        }
        MaterialInit.materials.add(this);
    }

    public ResourceLocation getLocationName() {
        return this.id;
    }

    @Nullable
    public Map<String, List<String>> getAliases() {
        return this.aliases;
    }

    @NotNull
    public MaterialConfig getConfig() {
        return (MaterialConfig)this.config.get();
    }

    public RegistryEntry<? extends Item> getTippedArrowEntry() {
        return this.tippedArrowEntry;
    }

    public RegistryEntry<? extends Item> getArrowEntry() {
        return this.arrowEntry;
    }

    public RegistryEntry<? extends Item> getBowEntry() {
        return this.bowEntry;
    }

    public RegistryEntry<? extends Item> getCrossbowEntry() {
        return this.crossbowEntry;
    }

    public RegistryEntry<? extends Item> getHalfBowEntry() {
        return this.halfBowEntry;
    }

    public RegistryEntry<? extends Item> getGauntletEntry() {
        return this.gauntletEntry;
    }

    public RegistryEntry<? extends Item> getQuiverEntry() {
        return this.quiverEntry;
    }

    public RegistryEntry<? extends Item> getWeaponEntry(String name) {
        return this.weaponEntries.get(name);
    }

    public Map<String, RegistryEntry<? extends Item>> getWeapons() {
        return this.weaponEntries;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Material getCraftedFrom() {
        return this.craftedFrom;
    }

    public Function<Float, Float> getAdditionalDamageAfterEnchantments() {
        return this.additionalDamageAfterEnchantments;
    }

    public boolean satifiesOnlyReplaceRequirement(String shieldMaterialName) {
        if (((MaterialConfig)this.config.get()).crafting.onlyReplaceResource.isEmpty()) {
            return true;
        }
        for (String name : ((MaterialConfig)this.config.get()).crafting.onlyReplaceResource) {
            if (!name.equals(shieldMaterialName)) continue;
            return true;
        }
        return false;
    }

    public static enum ShieldUse {
        ALL,
        NOT_TRIM;

    }
}

