/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expanded_combat;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.userofbricks.expanded_combat.api.material.Material;
import com.userofbricks.expanded_combat.api.registry.IExpandedCombatPlugin;
import com.userofbricks.expanded_combat.client.renderer.ECArrowRenderer;
import com.userofbricks.expanded_combat.client.renderer.ECFallingBlockRenderer;
import com.userofbricks.expanded_combat.client.renderer.gui.screen.inventory.FletchingTableScreen;
import com.userofbricks.expanded_combat.client.renderer.gui.screen.inventory.ShieldSmithingTableScreen;
import com.userofbricks.expanded_combat.client.renderer.item.ECItemModelsProperties;
import com.userofbricks.expanded_combat.config.ECConfig;
import com.userofbricks.expanded_combat.config.ECConfigGUIRegister;
import com.userofbricks.expanded_combat.events.ClientEvents;
import com.userofbricks.expanded_combat.events.EnchantentEvents;
import com.userofbricks.expanded_combat.events.GauntletEvents;
import com.userofbricks.expanded_combat.events.GeneralEvents;
import com.userofbricks.expanded_combat.events.KatanaEvents;
import com.userofbricks.expanded_combat.events.QuiverEvents;
import com.userofbricks.expanded_combat.events.ShieldEvents;
import com.userofbricks.expanded_combat.init.ECAttributes;
import com.userofbricks.expanded_combat.init.ECBlocks;
import com.userofbricks.expanded_combat.init.ECContainers;
import com.userofbricks.expanded_combat.init.ECCreativeTabs;
import com.userofbricks.expanded_combat.init.ECEnchantments;
import com.userofbricks.expanded_combat.init.ECEntities;
import com.userofbricks.expanded_combat.init.ECItems;
import com.userofbricks.expanded_combat.init.ECKeyRegistry;
import com.userofbricks.expanded_combat.init.ECLayerDefinitions;
import com.userofbricks.expanded_combat.init.ECLootModifiers;
import com.userofbricks.expanded_combat.init.ECParticles;
import com.userofbricks.expanded_combat.init.ECRecipeSerializerInit;
import com.userofbricks.expanded_combat.init.LangStrings;
import com.userofbricks.expanded_combat.init.MaterialInit;
import com.userofbricks.expanded_combat.init.SpriteSourceTypes;
import com.userofbricks.expanded_combat.item.ECGauntletItem;
import com.userofbricks.expanded_combat.item.ECItemTags;
import com.userofbricks.expanded_combat.item.ECQuiverItem;
import com.userofbricks.expanded_combat.network.ECNetworkHandler;
import com.userofbricks.expanded_combat.util.ECPluginFinder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="expanded_combat")
public class ExpandedCombat {
    public static final String MODID = "expanded_combat";
    public static final String GAUNTLET_CURIOS_IDENTIFIER = "hands";
    public static final String QUIVER_CURIOS_IDENTIFIER = "quiver_ec";
    public static final String ARROWS_CURIOS_IDENTIFIER = "arrows";
    public static final NonNullSupplier<Registrate> REGISTRATE = NonNullSupplier.lazy(() -> Registrate.create((String)MODID));
    public static final List<IExpandedCombatPlugin> PLUGINS = new ArrayList<IExpandedCombatPlugin>();
    public static ECConfig CONFIG;
    public static int maxQuiverSlots;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public ExpandedCombat() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> SpriteSourceTypes::load);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        PLUGINS.addAll(ECPluginFinder.getECPlugins());
        AutoConfig.register(ECConfig.class, Toml4jConfigSerializer::new);
        CONFIG = (ECConfig)AutoConfig.getConfigHolder(ECConfig.class).getConfig();
        LangStrings.registerLang();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        MaterialInit.loadClass();
        ECParticles.PARTICLE_OPTIONS.register(bus);
        ECAttributes.ATTRIBUTES.register(bus);
        ECEnchantments.loadClass();
        ECBlocks.register();
        ECItems.loadClass();
        ECItemTags.loadTags();
        ECCreativeTabs.loadClass();
        bus.addListener(ECRecipeSerializerInit::registerConditions);
        ECRecipeSerializerInit.RECIPE_TYPES.register(bus);
        ECRecipeSerializerInit.RECIPE_SERIALIZERS.register(bus);
        ECContainers.MENU_TYPES.register(bus);
        ECEntities.ENTITIES.register(bus);
        ECLootModifiers.GLOBAL_LOOT_MODIFIER_SERIALIZERS.register(bus);
        bus.addListener(this::comms);
        MinecraftForge.EVENT_BUS.addListener(GauntletEvents::DamageGauntletEvent);
        MinecraftForge.EVENT_BUS.register(QuiverEvents.class);
        MinecraftForge.EVENT_BUS.register(ShieldEvents.class);
        MinecraftForge.EVENT_BUS.register(KatanaEvents.class);
        MinecraftForge.EVENT_BUS.register(EnchantentEvents.class);
        bus.addListener(ECLayerDefinitions::registerLayers);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ECConfigGUIRegister::registerModsPage);
    }

    private void comms(InterModEnqueueEvent event) {
        if (ExpandedCombat.CONFIG.enableGauntlets) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(GAUNTLET_CURIOS_IDENTIFIER).build());
        }
        if (ExpandedCombat.CONFIG.enableQuivers) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(QUIVER_CURIOS_IDENTIFIER).cosmetic().icon(new ResourceLocation(MODID, "slot/empty_quiver_ec_slot")).hide().build());
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(ARROWS_CURIOS_IDENTIFIER).cosmetic().icon(new ResourceLocation(MODID, "slot/empty_arrows_slot")).hide().size(maxQuiverSlots).build());
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ECItems());
        MinecraftForge.EVENT_BUS.register((Object)new GeneralEvents());
        ECNetworkHandler.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
        MenuScreens.m_96206_((MenuType)((MenuType)ECContainers.SHIELD_SMITHING.get()), ShieldSmithingTableScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ECContainers.FLETCHING.get()), FletchingTableScreen::new);
        for (RegistryEntry<? extends Item> registryEntry : ECItems.ITEMS) {
            Object object = registryEntry.get();
            if (!(object instanceof ECGauntletItem)) continue;
            ECGauntletItem gauntletItem = (ECGauntletItem)object;
            CuriosRendererRegistry.register((Item)gauntletItem, gauntletItem.getGauntletRenderer());
        }
        for (Material material : MaterialInit.quiverMaterials) {
            ECQuiverItem quiverItem = (ECQuiverItem)((Object)material.getQuiverEntry().get());
            CuriosRendererRegistry.register((Item)quiverItem, quiverItem.getQuiverRenderer());
        }
        ECItemModelsProperties.registerModelOverides();
        MinecraftForge.EVENT_BUS.register(ECKeyRegistry.class);
        EntityRenderers.m_174036_((EntityType)((EntityType)ECEntities.EC_ARROW.get()), ECArrowRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ECEntities.EC_FALLING_BLOCK.get()), ECFallingBlockRenderer::new);
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    public static ResourceLocation modLoc(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        maxQuiverSlots = 0;
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }
}

