/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.concurrent.CompletableFuture;
import net.lionarius.skinrestorer.MojangSkinProvider;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.SkinStorage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginNetworkHandlerMixin {
    @Shadow
    @Nullable
    GameProfile f_10021_;
    @Shadow
    @Final
    static Logger f_10015_;
    private CompletableFuture<Property> skinrestorer_pendingSkin;

    @Inject(method={"acceptPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;checkCanJoin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/text/Text;")}, cancellable=true)
    public void waitForSkin(CallbackInfo ci) {
        if (this.skinrestorer_pendingSkin == null) {
            this.skinrestorer_pendingSkin = CompletableFuture.supplyAsync(() -> {
                f_10015_.debug("Fetching {}'s skin", (Object)this.f_10021_.getName());
                if (SkinRestorer.getSkinStorage().getSkin(this.f_10021_.getId()) == SkinStorage.DEFAULT_SKIN) {
                    SkinRestorer.getSkinStorage().setSkin(this.f_10021_.getId(), MojangSkinProvider.getSkin(this.f_10021_.getName()));
                }
                return SkinRestorer.getSkinStorage().getSkin(this.f_10021_.getId());
            });
        }
        if (!this.skinrestorer_pendingSkin.isDone()) {
            ci.cancel();
        }
    }

    @Inject(method={"addToServer"}, at={@At(value="HEAD")})
    public void applyRestoredSkinHook(ServerPlayer player, CallbackInfo ci) {
        if (this.skinrestorer_pendingSkin != null) {
            SkinRestorer.applyRestoredSkin(player.m_36316_(), this.skinrestorer_pendingSkin.getNow(SkinStorage.DEFAULT_SKIN));
        }
    }
}

