/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.command;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.lionarius.skinrestorer.MineskinSkinProvider;
import net.lionarius.skinrestorer.MojangSkinProvider;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.SkinStorage;
import net.lionarius.skinrestorer.enums.SkinVariant;
import net.lionarius.skinrestorer.util.TranslationUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;

public class SkinCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skin").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"mojang").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"skin_name", (ArgumentType)StringArgumentType.word()).executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), () -> MojangSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"skin_name"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), true, () -> MojangSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"skin_name")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"web").then(Commands.m_82127_((String)"classic").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.CLASSIC)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), true, () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.CLASSIC))))))).then(Commands.m_82127_((String)"slim").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.SLIM)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).requires(source -> source.m_6761_(3))).executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), true, () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.SLIM))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), () -> SkinStorage.DEFAULT_SKIN))).then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).executes(context -> SkinCommand.skinAction((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), true, () -> SkinStorage.DEFAULT_SKIN)))));
    }

    private static int skinAction(CommandSourceStack src, Collection<GameProfile> targets, boolean setByOperator, Supplier<Property> skinSupplier) {
        SkinRestorer.setSkinAsync(src.m_81377_(), targets, skinSupplier).thenAccept(pair -> {
            Collection profiles = (Collection)pair.right();
            Collection players = (Collection)pair.left();
            if (profiles.size() == 0) {
                src.m_81352_(Component.m_130674_((String)TranslationUtils.translation.skinActionFailed));
                return;
            }
            if (setByOperator) {
                src.m_288197_(() -> Component.m_130674_((String)String.format(TranslationUtils.translation.skinActionAffectedProfile, String.join((CharSequence)", ", profiles.stream().map(GameProfile::getName).toList()))), true);
                if (players.size() != 0) {
                    src.m_288197_(() -> Component.m_130674_((String)String.format(TranslationUtils.translation.skinActionAffectedPlayer, String.join((CharSequence)", ", players.stream().map(p -> p.m_36316_().getName()).toList()))), true);
                }
            } else {
                src.m_288197_(() -> Component.m_130674_((String)TranslationUtils.translation.skinActionOk), true);
            }
        });
        return targets.size();
    }

    private static int skinAction(CommandSourceStack src, Supplier<Property> skinSupplier) {
        if (src.m_230896_() == null) {
            return 0;
        }
        return SkinCommand.skinAction(src, Collections.singleton(src.m_230896_().m_36316_()), false, skinSupplier);
    }
}

