/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.lionarius.skinrestorer.SkinIO;
import net.lionarius.skinrestorer.SkinStorage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddPlayerPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.BiomeManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinRestorer
implements DedicatedServerModInitializer {
    private static SkinStorage skinStorage;
    public static final Logger LOGGER;
    private static final Gson gson;

    public static SkinStorage getSkinStorage() {
        return skinStorage;
    }

    public void onInitializeServer() {
        skinStorage = new SkinStorage(new SkinIO(FabricLoader.getInstance().getConfigDir().resolve("skinrestorer")));
    }

    public static void refreshPlayer(ServerPlayer player) {
        ArrayList equipment = Lists.newArrayList();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = player.m_6844_(slot);
            if (itemStack.m_41619_()) continue;
            equipment.add(Pair.of((Object)slot, (Object)itemStack.m_41777_()));
        }
        for (ServerPlayer observer : player.f_8924_.m_6846_().m_11314_()) {
            observer.f_8906_.m_9829_((Packet)new ClientboundPlayerInfoRemovePacket(List.of(player.m_20148_())));
            observer.f_8906_.m_9829_((Packet)ClientboundPlayerInfoUpdatePacket.m_247122_(Collections.singleton(player)));
            if (observer == player) continue;
            observer.f_8906_.m_9829_((Packet)new ClientboundRemoveEntitiesPacket(new int[]{player.m_19879_()}));
            observer.f_8906_.m_9829_((Packet)new ClientboundAddPlayerPacket((Player)player));
            observer.f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)player));
            observer.f_8906_.m_9829_((Packet)new ClientboundSetEntityDataPacket(player.m_19879_(), player.m_20088_().m_252804_()));
            if (!equipment.isEmpty()) {
                observer.f_8906_.m_9829_((Packet)new ClientboundSetEquipmentPacket(player.m_19879_(), (List)equipment));
            }
            if (!player.m_20159_()) continue;
            observer.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(player.m_20202_()));
        }
        player.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(player.m_9236_().m_220362_(), player.m_9236_().m_46472_(), BiomeManager.m_47877_((long)player.m_284548_().m_7328_()), player.f_8941_.m_9290_(), player.f_8941_.m_9293_(), player.m_9236_().m_46659_(), player.m_284548_().m_8584_(), 2, Optional.empty(), player.m_287157_()));
        player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        player.f_8906_.m_9829_((Packet)new ClientboundSetCarriedItemPacket(player.m_150109_().f_35977_));
        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityDataPacket(player.m_19879_(), player.m_20088_().m_252804_()));
        player.m_6885_();
        player.f_36095_.m_182423_();
        player.f_8906_.m_9829_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
        player.f_8906_.m_9829_((Packet)new ClientboundSetHealthPacket(player.m_21223_(), player.m_36324_().m_38702_(), player.m_36324_().m_38722_()));
        for (MobEffectInstance instance : player.m_21220_()) {
            player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), instance));
        }
        if (player.m_20159_()) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(player.m_20202_()));
        }
    }

    public static CompletableFuture<it.unimi.dsi.fastutil.Pair<Collection<ServerPlayer>, Collection<GameProfile>>> setSkinAsync(MinecraftServer server, Collection<GameProfile> targets, Supplier<Property> skinSupplier) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashSet<GameProfile> acceptedProfiles = new HashSet<GameProfile>();
            Property skin = (Property)skinSupplier.get();
            if (Objects.isNull(skin)) {
                LOGGER.error("Cannot get the skin for {}", targets.stream().findFirst().orElseThrow());
                return it.unimi.dsi.fastutil.Pair.of(null, Collections.emptySet());
            }
            for (GameProfile profile : targets) {
                SkinRestorer.getSkinStorage().setSkin(profile.getId(), skin);
                acceptedProfiles.add(profile);
            }
            return it.unimi.dsi.fastutil.Pair.of((Object)skin, acceptedProfiles);
        }).thenApplyAsync(pair -> {
            Property skin = (Property)pair.left();
            if (Objects.isNull(skin)) {
                return it.unimi.dsi.fastutil.Pair.of(Collections.emptySet(), Collections.emptySet());
            }
            Collection acceptedProfiles = (Collection)pair.right();
            HashSet<ServerPlayer> acceptedPlayers = new HashSet<ServerPlayer>();
            JsonObject newSkinJson = (JsonObject)gson.fromJson(new String(Base64.getDecoder().decode(skin.getValue()), StandardCharsets.UTF_8), JsonObject.class);
            newSkinJson.remove("timestamp");
            for (GameProfile profile : acceptedProfiles) {
                ServerPlayer player = server.m_6846_().m_11259_(profile.getId());
                if (player == null || SkinRestorer.arePropertiesEquals(newSkinJson, player.m_36316_())) continue;
                SkinRestorer.applyRestoredSkin(player.m_36316_(), skin);
                SkinRestorer.refreshPlayer(player);
                acceptedPlayers.add(player);
            }
            return it.unimi.dsi.fastutil.Pair.of(acceptedPlayers, (Object)acceptedProfiles);
        }, (Executor)server)).orTimeout(10L, TimeUnit.SECONDS).exceptionally(e -> it.unimi.dsi.fastutil.Pair.of(Collections.emptySet(), Collections.emptySet()));
    }

    public static void applyRestoredSkin(GameProfile profile, Property skin) {
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)skin);
    }

    private static boolean arePropertiesEquals(@NotNull JsonObject x, @NotNull GameProfile y) {
        Property py = y.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
        if (py == null) {
            return false;
        }
        try {
            JsonObject jy = (JsonObject)gson.fromJson(new String(Base64.getDecoder().decode(py.getValue()), StandardCharsets.UTF_8), JsonObject.class);
            jy.remove("timestamp");
            return x.equals((Object)jy);
        }
        catch (Exception ex) {
            LOGGER.info("Can not compare skin", (Throwable)ex);
            return false;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"SkinRestorer");
        gson = new Gson();
    }
}

