/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.client.render.item.RenderEarthboreGauntlet;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.MowzieToolItem;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemEarthboreGauntlet
extends MowzieToolItem
implements GeoItem {
    public static final String CONTROLLER_NAME = "controller";
    public static final String CONTROLLER_IDLE_NAME = "controller_idle";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation OPEN_ANIM = RawAnimation.begin().thenLoop("open");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");
    public static final String IDLE_ANIM_NAME = "idle";
    public static final String OPEN_ANIM_NAME = "open";
    public static final String ATTACK_ANIM_NAME = "attack";

    public ItemEarthboreGauntlet(Item.Properties properties) {
        super(-2.0f + ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.toolConfig.attackDamageValue, -4.0f + ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.toolConfig.attackSpeedValue, (Tier)Tiers.STONE, (TagKey<Block>)BlockTags.f_144282_, properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new RenderEarthboreGauntlet();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public boolean m_41465_() {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)playerIn);
        if (abilityCapability != null) {
            playerIn.m_6672_(handIn);
            if (stack.m_41773_() + 5 < stack.m_41776_() || ((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.breakable.get()).booleanValue()) {
                if (!worldIn.m_5776_()) {
                    AbilityHandler.INSTANCE.sendAbilityMessage(playerIn, AbilityHandler.TUNNELING_ABILITY);
                }
                playerIn.m_6672_(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
            }
            abilityCapability.getAbilityMap().get(AbilityHandler.TUNNELING_ABILITY).end();
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.durability.get();
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.0")).m_6270_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.1")).m_6270_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.2")).m_6270_(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.3")).m_6270_(ItemHandler.TOOLTIP_STYLE));
        if (!((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.breakable.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.4")).m_6270_(ItemHandler.TOOLTIP_STYLE));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, CONTROLLER_IDLE_NAME, 3, this::predicateIdle)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, CONTROLLER_NAME, 3, state -> PlayState.STOP).triggerableAnim(IDLE_ANIM_NAME, IDLE_ANIM).triggerableAnim(OPEN_ANIM_NAME, OPEN_ANIM).triggerableAnim(ATTACK_ANIM_NAME, ATTACK_ANIM)});
    }

    public <P extends Item> PlayState predicateIdle(AnimationState<P> event) {
        event.getController().setAnimation(IDLE_ANIM);
        return PlayState.CONTINUE;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability(entity);
        if (abilityCapability != null && abilityCapability.getActiveAbility() == null && entity.m_21211_() != stack && entity.m_9236_() instanceof ServerLevel) {
            this.triggerAnim((Entity)entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)entity.m_9236_())), CONTROLLER_NAME, ATTACK_ANIM_NAME);
        }
        return super.onEntitySwing(stack, entity);
    }

    @Override
    public ConfigHandler.ToolConfig getConfig() {
        return ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHBORE_GAUNTLET.toolConfig;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

