/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.FireballAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.IceBreathAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.SimplePlayerAnimationAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.TunnelingAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.WroughtAxeSlamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.WroughtAxeSwingAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.BoulderRollAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.GroundSlamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.RockSlingAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.SpawnBoulderAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.SpawnPillarAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SolarBeamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SolarFlareAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SunstrikeAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SupernovaAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.message.MessageInterruptAbility;
import com.bobmowzie.mowziesmobs.server.message.MessageJumpToAbilitySection;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerUseAbility;
import com.bobmowzie.mowziesmobs.server.message.MessageUseAbility;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public enum AbilityHandler {
    INSTANCE;

    public static final AbilityType<Player, FireballAbility> FIREBALL_ABILITY;
    public static final AbilityType<Player, SunstrikeAbility> SUNSTRIKE_ABILITY;
    public static final AbilityType<Player, SolarBeamAbility> SOLAR_BEAM_ABILITY;
    public static final AbilityType<Player, SolarFlareAbility> SOLAR_FLARE_ABILITY;
    public static final AbilityType<Player, SupernovaAbility> SUPERNOVA_ABILITY;
    public static final AbilityType<Player, WroughtAxeSwingAbility> WROUGHT_AXE_SWING_ABILITY;
    public static final AbilityType<Player, WroughtAxeSlamAbility> WROUGHT_AXE_SLAM_ABILITY;
    public static final AbilityType<Player, IceBreathAbility> ICE_BREATH_ABILITY;
    public static final AbilityType<Player, SpawnBoulderAbility> SPAWN_BOULDER_ABILITY;
    public static final AbilityType<Player, TunnelingAbility> TUNNELING_ABILITY;
    public static final AbilityType<Player, SimplePlayerAnimationAbility> HIT_BOULDER_ABILITY;
    public static final AbilityType<Player, SpawnPillarAbility> SPAWN_PILLAR_ABILITY;
    public static final AbilityType<Player, GroundSlamAbility> GROUND_SLAM_ABILITY;
    public static final AbilityType<Player, BoulderRollAbility> BOULDER_ROLL_ABILITY;
    public static final AbilityType<Player, SimplePlayerAnimationAbility> BACKSTAB_ABILITY;
    public static final AbilityType<Player, RockSlingAbility> ROCK_SLING;
    public static final AbilityType<Player, ? extends PlayerAbility>[] PLAYER_ABILITIES;

    @Nullable
    public AbilityCapability.IAbilityCapability getAbilityCapability(LivingEntity entity) {
        return CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.ABILITY_CAPABILITY);
    }

    @Nullable
    public Ability getAbility(LivingEntity entity, AbilityType<?, ?> abilityType) {
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null) {
            return abilityCapability.getAbilityMap().get(abilityType);
        }
        return null;
    }

    public <T extends LivingEntity> void sendAbilityMessage(T entity, AbilityType<?, ?> abilityType) {
        Ability instance;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null && (instance = abilityCapability.getAbilityMap().get(abilityType)) != null && instance.canUse()) {
            abilityCapability.activateAbility(entity, abilityType);
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageUseAbility(entity.m_19879_(), ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity(entity), abilityType)));
        }
    }

    public <T extends LivingEntity> void sendInterruptAbilityMessage(T entity, AbilityType<?, ?> abilityType) {
        Ability instance;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null && (instance = abilityCapability.getAbilityMap().get(abilityType)).isUsing()) {
            instance.interrupt();
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageInterruptAbility(entity.m_19879_(), ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity(entity), abilityType)));
        }
    }

    public <T extends Player> void sendPlayerTryAbilityMessage(T entity, AbilityType<?, ?> ability) {
        if (!entity.m_9236_().f_46443_ || !(entity instanceof LocalPlayer)) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability((LivingEntity)entity);
        if (abilityCapability != null) {
            MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerUseAbility(ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity((LivingEntity)entity), ability)));
        }
    }

    public <T extends LivingEntity> void sendJumpToSectionMessage(T entity, AbilityType<?, ?> abilityType, int sectionIndex) {
        Ability instance;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        if (abilityCapability != null && (instance = abilityCapability.getAbilityMap().get(abilityType)).isUsing()) {
            instance.jumpToSection(sectionIndex);
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageJumpToAbilitySection(entity.m_19879_(), ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity(entity), abilityType), sectionIndex));
        }
    }

    static {
        FIREBALL_ABILITY = new AbilityType<Player, FireballAbility>("fireball", FireballAbility::new);
        SUNSTRIKE_ABILITY = new AbilityType<Player, SunstrikeAbility>("sunstrike", SunstrikeAbility::new);
        SOLAR_BEAM_ABILITY = new AbilityType<Player, SolarBeamAbility>("solar_beam", SolarBeamAbility::new);
        SOLAR_FLARE_ABILITY = new AbilityType<Player, SolarFlareAbility>("solar_flare", SolarFlareAbility::new);
        SUPERNOVA_ABILITY = new AbilityType<Player, SupernovaAbility>("supernova", SupernovaAbility::new);
        WROUGHT_AXE_SWING_ABILITY = new AbilityType<Player, WroughtAxeSwingAbility>("wrought_axe_swing", WroughtAxeSwingAbility::new);
        WROUGHT_AXE_SLAM_ABILITY = new AbilityType<Player, WroughtAxeSlamAbility>("wrought_axe_slam", WroughtAxeSlamAbility::new);
        ICE_BREATH_ABILITY = new AbilityType<Player, IceBreathAbility>("ice_breath", IceBreathAbility::new);
        SPAWN_BOULDER_ABILITY = new AbilityType<Player, SpawnBoulderAbility>("spawn_boulder", SpawnBoulderAbility::new);
        TUNNELING_ABILITY = new AbilityType<Player, TunnelingAbility>("tunneling", TunnelingAbility::new);
        HIT_BOULDER_ABILITY = new AbilityType<Player, SimplePlayerAnimationAbility>("hit_boulder", (type, player) -> new SimplePlayerAnimationAbility(type, (Player)player, "hit_boulder", 10, false, false));
        SPAWN_PILLAR_ABILITY = new AbilityType<Player, SpawnPillarAbility>("spawn_pillar", SpawnPillarAbility::new);
        GROUND_SLAM_ABILITY = new AbilityType<Player, GroundSlamAbility>("ground_slam", GroundSlamAbility::new);
        BOULDER_ROLL_ABILITY = new AbilityType<Player, BoulderRollAbility>("boulder_roll", BoulderRollAbility::new);
        BACKSTAB_ABILITY = new AbilityType<Player, SimplePlayerAnimationAbility>("backstab", (type, player) -> new SimplePlayerAnimationAbility(type, (Player)player, "backstab", 12, true, true));
        ROCK_SLING = new AbilityType<Player, RockSlingAbility>("rock_sling", RockSlingAbility::new);
        PLAYER_ABILITIES = new AbilityType[]{SUNSTRIKE_ABILITY, SOLAR_BEAM_ABILITY, SOLAR_FLARE_ABILITY, SUPERNOVA_ABILITY, WROUGHT_AXE_SWING_ABILITY, WROUGHT_AXE_SLAM_ABILITY, ICE_BREATH_ABILITY, SPAWN_BOULDER_ABILITY, TUNNELING_ABILITY, HIT_BOULDER_ABILITY, BACKSTAB_ABILITY};
    }
}

