/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.client.ClientProxy;
import com.bobmowzie.mowziesmobs.client.gui.CustomBossBar;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerThirdPerson;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoFirstPersonRenderer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.item.ItemBlowgun;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public enum ClientEventHandler {
    INSTANCE;

    private static final ResourceLocation FROZEN_BLUR;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHandRender(RenderHandEvent event) {
        GeckoPlayer.GeckoPlayerFirstPerson geckoPlayer;
        PlayerCapability.IPlayerCapability playerCapability;
        if (!((Boolean)ConfigHandler.CLIENT.customPlayerAnims.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean shouldAnimate = false;
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
        if (abilityCapability != null) {
            boolean bl = shouldAnimate = abilityCapability.getActiveAbility() != null;
        }
        if (shouldAnimate && (playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY)) != null && (geckoPlayer = GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON) != null) {
            ModelGeckoPlayerFirstPerson geckoFirstPersonModel = (ModelGeckoPlayerFirstPerson)geckoPlayer.getModel();
            GeckoFirstPersonRenderer firstPersonRenderer = (GeckoFirstPersonRenderer)geckoPlayer.getPlayerRenderer();
            if (geckoFirstPersonModel != null && firstPersonRenderer != null) {
                if (!geckoFirstPersonModel.isUsingSmallArms() && ((AbstractClientPlayer)player).m_108564_().equals("slim")) {
                    firstPersonRenderer.setSmallArms();
                }
                event.setCanceled(true);
                if (event.isCanceled()) {
                    float delta = event.getPartialTick();
                    float f1 = Mth.m_14179_((float)delta, (float)player.f_19860_, (float)player.m_146909_());
                    firstPersonRenderer.renderItemInFirstPerson((AbstractClientPlayer)player, f1, delta, event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), geckoPlayer);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        if (event.getEntity() instanceof Player) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;
            PlayerCapability.IPlayerCapability playerCapability;
            if (!((Boolean)ConfigHandler.CLIENT.customPlayerAnims.get()).booleanValue()) {
                return;
            }
            Player player = (Player)event.getEntity();
            if (player == null) {
                return;
            }
            float delta = event.getPartialTick();
            AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
            if (abilityCapability != null && abilityCapability.getActiveAbility() != null && (playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY)) != null && (geckoPlayer = playerCapability.getGeckoPlayer()) != null) {
                ModelGeckoPlayerThirdPerson geckoPlayerModel = (ModelGeckoPlayerThirdPerson)geckoPlayer.getModel();
                GeckoRenderPlayer animatedPlayerRenderer = (GeckoRenderPlayer)geckoPlayer.getPlayerRenderer();
                if (geckoPlayerModel != null && animatedPlayerRenderer != null) {
                    event.setCanceled(true);
                    if (event.isCanceled()) {
                        animatedPlayerRenderer.render((AbstractClientPlayer)event.getEntity(), event.getEntity().m_146908_(), delta, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), geckoPlayer);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        Player player = event.player;
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null && event.side == LogicalSide.CLIENT) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer = playerCapability.getGeckoPlayer();
            if (geckoPlayer != null) {
                geckoPlayer.tick();
            }
            if (player == Minecraft.m_91087_().f_91074_) {
                GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON.tick();
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.FROZEN_CAPABILITY);
        if (frozenCapability != null && frozenCapability.getFrozen() && frozenCapability.getPrevFrozen()) {
            player.m_146922_(frozenCapability.getFrozenYaw());
            player.m_146926_(frozenCapability.getFrozenPitch());
            player.f_20885_ = frozenCapability.getFrozenYawHead();
            player.f_19859_ = player.m_146908_();
            player.f_19860_ = player.m_146909_();
            player.f_20886_ = player.f_20885_;
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.FROZEN_CAPABILITY);
        if (frozenCapability != null && frozenCapability.getFrozen() && frozenCapability.getPrevFrozen()) {
            entity.f_19859_ = frozenCapability.getFrozenYaw();
            entity.m_146922_(entity.f_19859_);
            entity.f_19860_ = frozenCapability.getFrozenPitch();
            entity.m_146926_(entity.f_19860_);
            entity.f_20885_ = entity.f_20886_ = frozenCapability.getFrozenYawHead();
            entity.f_20883_ = entity.f_20884_ = frozenCapability.getFrozenRenderYawOffset();
            entity.f_20921_ = entity.f_20920_ = frozenCapability.getFrozenSwingProgress();
            entity.f_267362_.m_267771_(frozenCapability.getFrozenWalkAnimSpeed());
            entity.f_267362_.f_267358_ = frozenCapability.getFrozenWalkAnimPosition();
            entity.m_20260_(false);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiOverlayEvent.Post e) {
        FrozenCapability.IFrozenCapability frozenCapability;
        int startTime = 210;
        int pointStart = 1200;
        int timePerMillis = 22;
        if (e.getOverlay() == VanillaGuiOverlay.FROSTBITE.type() && Minecraft.m_91087_().f_91074_ != null && (frozenCapability = CapabilityHandler.getCapability((Entity)Minecraft.m_91087_().f_91074_, CapabilityHandler.FROZEN_CAPABILITY)) != null && frozenCapability.getFrozen() && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            Window res = e.getWindow();
            e.getGuiGraphics().m_280163_(FROZEN_BLUR, 0, 0, 0.0f, 0.0f, res.m_85445_(), res.m_85446_(), res.m_85445_(), res.m_85446_());
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20159_() && player.m_20202_() instanceof EntityFrozenController) {
            if (event.getOverlay() == VanillaGuiOverlay.MOUNT_HEALTH.type()) {
                event.setCanceled(true);
            }
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237119_(), false);
        }
    }

    @SubscribeEvent
    public void updateFOV(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (player.m_6117_() && player.m_21211_().m_41720_() instanceof ItemBlowgun) {
            int i = player.m_21252_();
            float f1 = (float)i / 5.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewFovModifier(1.0f - f1 * 0.15f);
        }
    }

    @SubscribeEvent
    public void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float delta = Minecraft.m_91087_().m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        if (player != null && ((Boolean)ConfigHandler.CLIENT.doCameraShakes.get()).booleanValue() && !Minecraft.m_91087_().m_91104_()) {
            float shakeAmplitude = 0.0f;
            for (EntityCameraShake cameraShake : player.m_9236_().m_45976_(EntityCameraShake.class, player.m_20191_().m_82377_(20.0, 20.0, 20.0))) {
                if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (!((Boolean)ConfigHandler.CLIENT.customBossBars.get()).booleanValue()) {
            return;
        }
        ResourceLocation bossRegistryName = ClientProxy.bossBarRegistryNames.getOrDefault(event.getBossEvent().m_18860_(), null);
        if (bossRegistryName == null) {
            return;
        }
        CustomBossBar customBossBar = CustomBossBar.customBossBars.getOrDefault(bossRegistryName, null);
        if (customBossBar == null) {
            return;
        }
        event.setCanceled(true);
        customBossBar.renderBossBar(event);
    }

    static {
        FROZEN_BLUR = new ResourceLocation("textures/misc/powder_snow_outline.png");
    }
}

