/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.PushReaction;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlantLike;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class BlocksHelper {
    private static final Map<Block, Integer> COLOR_BY_BLOCK = Maps.newHashMap();
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 18;
    public static final int SET_OBSERV = 3;
    public static final Direction[] HORIZONTAL = BlocksHelper.makeHorizontal();
    public static final Direction[] DIRECTIONS = Direction.values();
    private static final ThreadLocal<BlockPos.MutableBlockPos> TL_POS = ThreadLocal.withInitial(() -> new BlockPos.MutableBlockPos());
    protected static final BlockState AIR = Blocks.f_50016_.m_49966_();
    protected static final BlockState WATER = Blocks.f_49990_.m_49966_();

    public static void addBlockColor(Block block, int color) {
        COLOR_BY_BLOCK.put(block, color);
    }

    public static int getBlockColor(Block block) {
        return COLOR_BY_BLOCK.getOrDefault(block, -16777216);
    }

    public static void setWithoutUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, state, 18);
    }

    public static void setWithoutUpdate(LevelAccessor world, BlockPos pos, Block block) {
        world.m_7731_(pos, block.m_49966_(), 18);
    }

    public static void setWithUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, state, 3);
    }

    public static void setWithUpdate(LevelAccessor world, BlockPos pos, Block block) {
        world.m_7731_(pos, block.m_49966_(), 3);
    }

    public static int upRay(LevelAccessor world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.m_46859_(pos.m_6630_(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(LevelAccessor world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.m_46859_(pos.m_6625_(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRayRep(LevelAccessor world, BlockPos pos, int maxDist) {
        BlockPos.MutableBlockPos POS = TL_POS.get();
        POS.m_122190_((Vec3i)pos);
        for (int j = 1; j < maxDist && world.m_8055_((BlockPos)POS).m_247087_(); ++j) {
            POS.m_142448_(POS.m_123342_() - 1);
        }
        return pos.m_123342_() - POS.m_123342_();
    }

    public static int raycastSqr(LevelAccessor world, BlockPos pos, int dx, int dy, int dz, int maxDist) {
        BlockPos.MutableBlockPos POS = TL_POS.get();
        POS.m_122190_((Vec3i)pos);
        for (int j = 1; j < maxDist && world.m_8055_((BlockPos)POS).m_247087_(); ++j) {
            POS.m_122184_(dx, dy, dz);
        }
        return (int)pos.m_123331_((Vec3i)POS);
    }

    public static BlockState rotateHorizontal(BlockState state, Rotation rotation, Property<Direction> facing) {
        return (BlockState)state.m_61124_(facing, (Comparable)rotation.m_55954_((Direction)state.m_61143_(facing)));
    }

    public static BlockState mirrorHorizontal(BlockState state, Mirror mirror, Property<Direction> facing) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(facing)));
    }

    public static int getLengthDown(LevelAccessor world, BlockPos pos, Block block) {
        int count = 1;
        while (world.m_8055_(pos.m_6625_(count)).m_60734_() == block) {
            ++count;
        }
        return count;
    }

    public static Direction[] makeHorizontal() {
        return new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    }

    public static Direction randomHorizontal(RandomSource random) {
        return HORIZONTAL[random.m_188503_(4)];
    }

    public static Direction randomDirection(RandomSource random) {
        return DIRECTIONS[random.m_188503_(6)];
    }

    public static boolean isInvulnerable(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60800_(world, pos) < 0.0f;
    }

    public static boolean isInvulnerableUnsafe(BlockState state) {
        try {
            return BlocksHelper.isInvulnerable(state, null, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Optional<BlockPos> findSurfaceBelow(LevelAccessor level, BlockPos startPos, int minY, Predicate<BlockState> surface) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
        for (int y = startPos.m_123342_(); y >= minY; --y) {
            POS.m_142448_(y);
            if (!surface.test(level.m_8055_((BlockPos)POS))) continue;
            return Optional.of(POS);
        }
        return Optional.empty();
    }

    public static boolean findSurface(LevelAccessor level, BlockPos.MutableBlockPos startPos, Direction dir, int length, Predicate<BlockState> surface) {
        for (int len = 0; len < length; ++len) {
            if (surface.test(level.m_8055_((BlockPos)startPos))) {
                return true;
            }
            startPos.m_122175_(dir, 1);
        }
        return false;
    }

    public static boolean findOnSurroundingSurface(LevelAccessor level, BlockPos.MutableBlockPos startPos, Direction dir, int length, Predicate<BlockState> surface) {
        for (int len = 0; len < length; ++len) {
            if (surface.test(level.m_8055_((BlockPos)startPos))) {
                if (len == 0) {
                    for (int lenUp = 0; lenUp < length; ++lenUp) {
                        startPos.m_122175_(dir, -1);
                        if (surface.test(level.m_8055_((BlockPos)startPos))) continue;
                        return true;
                    }
                    return false;
                }
                startPos.m_122175_(dir, -1);
                return true;
            }
            startPos.m_122175_(dir, 1);
        }
        return false;
    }

    public static boolean findSurroundingSurface(LevelAccessor level, BlockPos.MutableBlockPos startPos, Direction dir, int length, Predicate<BlockState> surface) {
        BlockState beforeState = null;
        for (int len = 0; len < length; ++len) {
            BlockState nowState = level.m_8055_((BlockPos)startPos);
            if (surface.test(nowState)) {
                if (len == 0) {
                    beforeState = nowState;
                    for (int lenUp = 0; lenUp < length; ++lenUp) {
                        startPos.m_122175_(dir, -1);
                        nowState = level.m_8055_((BlockPos)startPos);
                        if (BlocksHelper.isFree(nowState)) {
                            return surface.test(beforeState);
                        }
                        beforeState = nowState;
                    }
                    return false;
                }
                startPos.m_122175_(dir, -1);
                return BlocksHelper.isFree(beforeState);
            }
            beforeState = nowState;
            startPos.m_122175_(dir, 1);
        }
        return false;
    }

    public static boolean isFreeSpace(LevelAccessor level, BlockPos startPos, Direction dir, int length, Predicate<BlockState> freeSurface) {
        BlockPos.MutableBlockPos POS = startPos.m_122032_();
        for (int len = 0; len < length; ++len) {
            if (!freeSurface.test(level.m_8055_((BlockPos)POS))) {
                return false;
            }
            POS.m_122175_(dir, 1);
        }
        return true;
    }

    public static int blockCount(LevelAccessor level, BlockPos startPos, Direction dir, int length, Predicate<BlockState> freeSurface) {
        BlockPos.MutableBlockPos POS = startPos.m_122032_();
        for (int len = 0; len < length; ++len) {
            if (!freeSurface.test(level.m_8055_((BlockPos)POS))) {
                return len;
            }
            POS.m_122175_(dir, 1);
        }
        return length;
    }

    public static boolean isLava(BlockState state) {
        return state.m_60819_().m_76152_() instanceof LavaFluid;
    }

    public static boolean isFluid(BlockState state) {
        return state.m_278721_();
    }

    public static boolean isFree(BlockState state) {
        return state.m_60795_();
    }

    public static boolean isFreeOrReplaceable(BlockState state) {
        return state.m_60795_() || state.m_247087_();
    }

    public static boolean isFreeOrFluid(BlockState state) {
        return state.m_60795_() || BlocksHelper.isFluid(state);
    }

    public static boolean isTerrain(BlockState state) {
        return state.m_204336_(CommonBlockTags.TERRAIN);
    }

    public static boolean isTerrainOrFluid(BlockState state) {
        return state.m_204336_(CommonBlockTags.TERRAIN) || BlocksHelper.isFluid(state);
    }

    public static Boolean replaceableOrPlant(BlockState state) {
        Block block = state.m_60734_();
        if (state.m_204336_(CommonBlockTags.PLANT) || state.m_204336_(CommonBlockTags.WATER_PLANT) || block instanceof BehaviourPlantLike) {
            return true;
        }
        if (state.m_60811_() == PushReaction.DESTROY && block.m_155943_() == 0.0f) {
            return true;
        }
        if (state.m_60827_() == SoundType.f_56740_ || state.m_60827_() == SoundType.f_56752_ || state.m_60827_() == SoundType.f_56758_ || state.m_60827_() == SoundType.f_154664_) {
            return true;
        }
        return state.m_247087_();
    }

    public static void forAllInBounds(BoundingBox bb, Consumer<BlockPos> worker) {
        for (int x = bb.m_162395_(); x <= bb.m_162399_(); ++x) {
            for (int y = bb.m_162396_(); y <= bb.m_162400_(); ++y) {
                for (int z = bb.m_162398_(); z <= bb.m_162401_(); ++z) {
                    BlockPos bp = new BlockPos(x, y, z);
                    worker.accept(bp);
                }
            }
        }
    }

    public static void forOutlineInBounds(BoundingBox bb, Consumer<BlockPos> worker) {
        for (int x = bb.m_162395_(); x <= bb.m_162399_(); ++x) {
            worker.accept(new BlockPos(x, bb.m_162396_(), bb.m_162398_()));
            worker.accept(new BlockPos(x, bb.m_162400_(), bb.m_162398_()));
            worker.accept(new BlockPos(x, bb.m_162396_(), bb.m_162401_()));
            worker.accept(new BlockPos(x, bb.m_162400_(), bb.m_162401_()));
        }
        for (int y = bb.m_162396_(); y <= bb.m_162400_(); ++y) {
            worker.accept(new BlockPos(bb.m_162395_(), y, bb.m_162398_()));
            worker.accept(new BlockPos(bb.m_162399_(), y, bb.m_162398_()));
            worker.accept(new BlockPos(bb.m_162395_(), y, bb.m_162401_()));
            worker.accept(new BlockPos(bb.m_162399_(), y, bb.m_162401_()));
        }
        for (int z = bb.m_162398_(); z <= bb.m_162401_(); ++z) {
            worker.accept(new BlockPos(bb.m_162395_(), bb.m_162396_(), z));
            worker.accept(new BlockPos(bb.m_162399_(), bb.m_162396_(), z));
            worker.accept(new BlockPos(bb.m_162395_(), bb.m_162400_(), z));
            worker.accept(new BlockPos(bb.m_162399_(), bb.m_162400_(), z));
        }
    }
}

