/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.registry;

import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.registry.BaseRegistry;

public class BlockRegistry
extends BaseRegistry<Block> {
    public BlockRegistry(PathConfig config) {
        super(config);
    }

    @Override
    public Block register(ResourceLocation id, Block block) {
        if (!this.config.getBooleanRoot(id.m_135827_(), true)) {
            BCLib.LOGGER.warning("Block " + id + " disabled", new Object[0]);
            return block;
        }
        block = (Block)Registry.m_122965_((Registry)BuiltInRegistries.f_256975_, (ResourceLocation)id, (Object)block);
        BlockItem item = null;
        item = block instanceof CustomItemProvider ? ((CustomItemProvider)block).getCustomItem(id, this.makeItemSettings()) : new BlockItem(block, this.makeItemSettings());
        this.registerBlockItem(id, item);
        if (block.m_49966_().m_278200_() && ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(block)).getBurnChance() == 0) {
            FlammableBlockRegistry.getDefaultInstance().add(block, 5, 5);
        }
        BlockRegistry.getModBlocks(id.m_135827_()).add(block);
        return block;
    }

    public Block registerBlockOnly(ResourceLocation id, Block block) {
        if (!this.config.getBooleanRoot(id.m_135827_(), true)) {
            return block;
        }
        BlockRegistry.getModBlocks(id.m_135827_()).add(block);
        return (Block)Registry.m_122965_((Registry)BuiltInRegistries.f_256975_, (ResourceLocation)id, (Object)block);
    }

    private Item registerBlockItem(ResourceLocation id, BlockItem item) {
        this.registerItem(id, (Item)item);
        return item;
    }

    @Override
    public void registerItem(ResourceLocation id, Item item) {
        if (item != null && item != Items.f_41852_) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)id, (Object)item);
            BlockRegistry.getModBlockItems(id.m_135827_()).add(item);
        }
    }
}

