/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.Container;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.util.DatapackConfigs;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class BCLRecipeManager {
    private static final HashSet<ResourceLocation> disabledRecipes = new HashSet();

    public static <C extends Container, S extends RecipeSerializer<T>, T extends Recipe<C>> S registerSerializer(String modID, String id, S serializer) {
        return (S)((RecipeSerializer)Registry.m_122961_((Registry)BuiltInRegistries.f_256769_, (String)(modID + ":" + id), serializer));
    }

    public static <C extends Container, T extends Recipe<C>> RecipeType<T> registerType(String modID, final String type) {
        ResourceLocation recipeTypeId = new ResourceLocation(modID, type);
        return (RecipeType)Registry.m_122965_((Registry)BuiltInRegistries.f_256990_, (ResourceLocation)recipeTypeId, (Object)new RecipeType<T>(){

            public String toString() {
                return type;
            }
        });
    }

    public static boolean exists(ItemLike item) {
        if (item instanceof Block) {
            return BuiltInRegistries.f_256975_.m_7981_((Object)((Block)item)) != BuiltInRegistries.f_256975_.m_122315_();
        }
        return item != Items.f_41852_ && BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()) != BuiltInRegistries.f_257033_.m_122315_();
    }

    private static void clearRecipeConfig() {
        disabledRecipes.clear();
    }

    private static void processRecipeConfig(@NotNull ResourceLocation sourceId, @NotNull JsonObject root) {
        if (root.has("disable")) {
            root.getAsJsonArray("disable").asList().stream().map(el -> ResourceLocation.m_135820_((String)el.getAsString())).filter(id -> id != null).forEach(disabledRecipes::add);
        }
    }

    @ApiStatus.Internal
    public static void removeDisabledRecipes(ResourceManager manager, Map<ResourceLocation, JsonElement> map) {
        BCLRecipeManager.clearRecipeConfig();
        DatapackConfigs.instance().runForResources(manager, "bclib", "recipes.json", BCLRecipeManager::processRecipeConfig);
        for (ResourceLocation id : disabledRecipes) {
            if (Configs.MAIN_CONFIG.verboseLogging()) {
                BCLib.LOGGER.info("Disabling Recipe: {}", id);
            }
            map.remove(id);
        }
    }
}

