/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AbstractSingleInputRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.NotNull;

public class AnvilRecipe
implements Recipe<Container>,
UnknownReceipBookCategory {
    public static final String GROUP = "smithing";
    public static final RecipeType<AnvilRecipe> TYPE = BCLRecipeManager.registerType("bclib", "smithing");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer("bclib", "smithing", new Serializer());
    public static final ResourceLocation ID = BCLib.makeID("smithing");
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final int damage;
    private final int toolLevel;
    private final int anvilLevel;
    private final int inputCount;

    public static void register() {
    }

    public AnvilRecipe(ResourceLocation identifier, Ingredient input, ItemStack output, int inputCount, int toolLevel, int anvilLevel, int damage) {
        this.id = identifier;
        this.input = input;
        this.output = output;
        this.toolLevel = toolLevel;
        this.anvilLevel = anvilLevel;
        this.inputCount = inputCount;
        this.damage = damage;
    }

    static Builder create(ResourceLocation id, ItemLike output) {
        return new Builder(id, output);
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public ItemStack m_8043_(RegistryAccess acc) {
        return this.output;
    }

    public boolean m_5818_(@NotNull Container craftingInventory, @NotNull Level world) {
        return this.matches(craftingInventory);
    }

    public ItemStack m_5874_(@NotNull Container craftingInventory, RegistryAccess acc) {
        return this.output.m_41777_();
    }

    public static Iterable<Holder<Item>> getAllHammers() {
        Registry registry = WorldBootstrap.getLastRegistryAccessOrElseBuiltin().m_175515_(CommonItemTags.HAMMERS.f_203867_());
        return registry.m_206058_(CommonItemTags.HAMMERS);
    }

    public static int getHammerSlot(Container c) {
        ItemStack h = c.m_8020_(0);
        if (!h.m_41619_() && h.m_204117_(CommonItemTags.HAMMERS)) {
            return 0;
        }
        return 1;
    }

    public static int getIngredientSlot(Container c) {
        return Math.abs(AnvilRecipe.getHammerSlot(c) - 1);
    }

    public ItemStack getHammer(Container c) {
        ItemStack h = c.m_8020_(1);
        if (!h.m_41619_() && h.m_204117_(CommonItemTags.HAMMERS)) {
            return h;
        }
        h = c.m_8020_(0);
        if (!h.m_41619_() && h.m_204117_(CommonItemTags.HAMMERS)) {
            return h;
        }
        return null;
    }

    public ItemStack getIngredient(Container c) {
        ItemStack i = c.m_8020_(0);
        if (i.m_204117_(CommonItemTags.HAMMERS)) {
            i = c.m_8020_(1);
        }
        return i;
    }

    public ItemStack craft(Container craftingInventory, Player player) {
        if (!player.m_7500_()) {
            if (!this.checkHammerDurability(craftingInventory, player)) {
                return ItemStack.f_41583_;
            }
            ItemStack hammer = this.getHammer(craftingInventory);
            if (hammer != null) {
                hammer.m_41622_(this.damage, (LivingEntity)player, entity -> entity.m_21190_((InteractionHand)null));
                return ItemStack.f_41583_;
            }
        }
        return this.m_5874_(craftingInventory, Minecraft.m_91087_().f_91073_.m_9598_());
    }

    public boolean checkHammerDurability(Container craftingInventory, Player player) {
        if (player.m_7500_()) {
            return true;
        }
        ItemStack hammer = this.getHammer(craftingInventory);
        if (hammer != null) {
            int damage = hammer.m_41773_() + this.damage;
            return damage < hammer.m_41776_();
        }
        return true;
    }

    public boolean matches(Container craftingInventory) {
        ItemStack hammer = this.getHammer(craftingInventory);
        if (hammer == null) {
            return false;
        }
        ItemStack material = this.getIngredient(craftingInventory);
        int materialCount = material.m_41613_();
        int level = ((TieredItem)hammer.m_41720_()).m_43314_().m_6604_();
        return this.input.test(this.getIngredient(craftingInventory)) && materialCount >= this.inputCount && level >= this.toolLevel;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public Ingredient getMainIngredient() {
        return this.input;
    }

    public int getAnvilLevel() {
        return this.anvilLevel;
    }

    public boolean canUse(Item tool) {
        if (tool instanceof TieredItem) {
            TieredItem ti = (TieredItem)tool;
            return ti.m_43314_().m_6604_() >= this.toolLevel;
        }
        return false;
    }

    public static boolean isHammer(Item tool) {
        if (tool == null) {
            return false;
        }
        return tool.m_7968_().m_204117_(CommonItemTags.HAMMERS);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList defaultedList = NonNullList.m_122779_();
        defaultedList.add((Object)Ingredient.m_43921_(BuiltInRegistries.f_257033_.m_123024_().filter(AnvilRecipe::isHammer).filter(this::canUse).map(ItemStack::new)));
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnvilRecipe that = (AnvilRecipe)o;
        return this.damage == that.damage && this.toolLevel == that.toolLevel && this.id.equals((Object)that.id) && this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.input, this.output, this.damage, this.toolLevel);
    }

    public String toString() {
        return "AnvilRecipe [" + this.id + "]";
    }

    public static class Builder
    extends AbstractSingleInputRecipeBuilder<Builder, AnvilRecipe> {
        private int inputCount = 1;
        private int toolLevel = 1;
        private int anvilLevel = 1;
        private int damage = 1;

        protected Builder(ResourceLocation id, ItemLike output) {
            super(id, output);
        }

        @Override
        protected Builder setOutputTag(CompoundTag tag) {
            return (Builder)super.setOutputTag(tag);
        }

        @Override
        protected Builder setOutputCount(int count) {
            return (Builder)super.setOutputCount(count);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(ItemLike ... inputItems) {
            return (Builder)super.setPrimaryInput(inputItems);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(TagKey<Item> inputTag) {
            return (Builder)super.setPrimaryInput(inputTag);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(Ingredient ingredient) {
            this.primaryInput = ingredient;
            return this;
        }

        public Builder setInputCount(int count) {
            this.inputCount = count;
            return this;
        }

        public Builder setToolLevel(int level) {
            this.toolLevel = level;
            return this;
        }

        public Builder setAnvilLevel(int level) {
            this.anvilLevel = level;
            return this;
        }

        public Builder setDamage(int damage) {
            this.damage = damage;
            return this;
        }

        @Override
        protected RecipeSerializer<AnvilRecipe> getSerializer() {
            return SERIALIZER;
        }

        @Override
        protected boolean checkRecipe() {
            if (this.inputCount <= 0) {
                BCLib.LOGGER.warning("Number of input items for Recipe must be positive. Recipe {} will be ignored!", this.id);
                return false;
            }
            return super.checkRecipe();
        }

        @Override
        protected void serializeRecipeData(JsonObject root) {
            super.serializeRecipeData(root);
            if (this.inputCount > 1) {
                root.addProperty("inputCount", (Number)this.inputCount);
            }
            if (this.toolLevel != 1) {
                root.addProperty("toolLevel", (Number)this.toolLevel);
            }
            if (this.anvilLevel != 1) {
                root.addProperty("anvilLevel", (Number)this.anvilLevel);
            }
            if (this.damage != 1) {
                root.addProperty("damage", (Number)this.damage);
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<AnvilRecipe> {
        public AnvilRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack output = ItemUtil.fromJsonRecipeWithNBT(result);
            if (output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            int inputCount = GsonHelper.m_13824_((JsonObject)json, (String)"inputCount", (int)1);
            int toolLevel = GsonHelper.m_13824_((JsonObject)json, (String)"toolLevel", (int)1);
            int anvilLevel = GsonHelper.m_13824_((JsonObject)json, (String)"anvilLevel", (int)1);
            int damage = GsonHelper.m_13824_((JsonObject)json, (String)"damage", (int)1);
            return new AnvilRecipe(id, input, output, inputCount, toolLevel, anvilLevel, damage);
        }

        public AnvilRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf packetBuffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            ItemStack output = packetBuffer.m_130267_();
            int inputCount = packetBuffer.m_130242_();
            int toolLevel = packetBuffer.m_130242_();
            int anvilLevel = packetBuffer.m_130242_();
            int damage = packetBuffer.m_130242_();
            return new AnvilRecipe(id, input, output, inputCount, toolLevel, anvilLevel, damage);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, AnvilRecipe recipe) {
            recipe.input.m_43923_(packetBuffer);
            packetBuffer.m_130055_(recipe.output);
            packetBuffer.m_130130_(recipe.inputCount);
            packetBuffer.m_130130_(recipe.toolLevel);
            packetBuffer.m_130130_(recipe.anvilLevel);
            packetBuffer.m_130130_(recipe.damage);
        }
    }
}

