/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AbstractDoubleInputRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;

public class AlloyingRecipe
implements Recipe<Container>,
UnknownReceipBookCategory {
    public static final String GROUP = "alloying";
    public static final RecipeType<AlloyingRecipe> TYPE = BCLRecipeManager.registerType("bclib", "alloying");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer("bclib", "alloying", new Serializer());
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    protected final Ingredient primaryInput;
    protected final Ingredient secondaryInput;
    protected final ItemStack output;
    protected final String group;
    protected final float experience;
    protected final int smeltTime;

    public AlloyingRecipe(ResourceLocation id, String group, Ingredient primaryInput, Ingredient secondaryInput, ItemStack output, float experience, int smeltTime) {
        this.group = group;
        this.id = id;
        this.primaryInput = primaryInput;
        this.secondaryInput = secondaryInput;
        this.output = output;
        this.experience = experience;
        this.smeltTime = smeltTime;
        this.type = TYPE;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList defaultedList = NonNullList.m_122779_();
        defaultedList.add((Object)this.primaryInput);
        defaultedList.add((Object)this.secondaryInput);
        return defaultedList;
    }

    public boolean m_5818_(Container inv, Level world) {
        return this.primaryInput.test(inv.m_8020_(0)) && this.secondaryInput.test(inv.m_8020_(1)) || this.primaryInput.test(inv.m_8020_(1)) && this.secondaryInput.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess acc) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public static void register() {
    }

    public static class Serializer
    implements RecipeSerializer<AlloyingRecipe> {
        public AlloyingRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            Ingredient primaryInput = Ingredient.m_43917_((JsonElement)ingredients.get(0));
            Ingredient secondaryInput = Ingredient.m_43917_((JsonElement)ingredients.get(1));
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack output = ItemUtil.fromJsonRecipeWithNBT(result);
            if (output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int smeltTime = GsonHelper.m_13824_((JsonObject)json, (String)"smelttime", (int)350);
            return new AlloyingRecipe(id, group, primaryInput, secondaryInput, output, experience, smeltTime);
        }

        public AlloyingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf packetBuffer) {
            String group = packetBuffer.m_130136_(Short.MAX_VALUE);
            Ingredient primary = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            Ingredient secondary = Ingredient.m_43940_((FriendlyByteBuf)packetBuffer);
            ItemStack output = packetBuffer.m_130267_();
            float experience = packetBuffer.readFloat();
            int smeltTime = packetBuffer.m_130242_();
            return new AlloyingRecipe(id, group, primary, secondary, output, experience, smeltTime);
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, AlloyingRecipe recipe) {
            packetBuffer.m_130070_(recipe.group);
            recipe.primaryInput.m_43923_(packetBuffer);
            recipe.secondaryInput.m_43923_(packetBuffer);
            packetBuffer.m_130055_(recipe.output);
            packetBuffer.writeFloat(recipe.experience);
            packetBuffer.m_130130_(recipe.smeltTime);
        }
    }

    public static class Builder
    extends AbstractDoubleInputRecipeBuilder<Builder, AlloyingRecipe> {
        private float experience = 0.0f;
        private int smeltTime = 350;

        private Builder(ResourceLocation id, ItemLike output) {
            super(id, output);
        }

        static Builder create(ResourceLocation id, ItemLike output) {
            return new Builder(id, output);
        }

        @Override
        public Builder setOutputCount(int count) {
            return (Builder)super.setOutputCount(count);
        }

        @Override
        public Builder setOutputTag(CompoundTag tag) {
            return (Builder)super.setOutputTag(tag);
        }

        public Builder setInput(ItemLike primaryInput, ItemLike secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        public Builder setInput(TagKey<Item> primaryInput, TagKey<Item> secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        public Builder setExperience(float amount) {
            this.experience = amount;
            return this;
        }

        public Builder setSmeltTime(int time) {
            this.smeltTime = time;
            return this;
        }

        @Override
        public Builder setGroup(String group) {
            return (Builder)super.setGroup(group);
        }

        @Override
        protected boolean checkRecipe() {
            if (this.smeltTime < 0) {
                BCLib.LOGGER.warning("Semelt-time for recipe {} most be positive!", this.id);
                return false;
            }
            return super.checkRecipe();
        }

        @Override
        protected RecipeSerializer<AlloyingRecipe> getSerializer() {
            return SERIALIZER;
        }

        @Override
        protected void serializeRecipeData(JsonObject root) {
            super.serializeRecipeData(root);
            if (this.experience != 0.0f) {
                root.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            if (this.experience != 350.0f) {
                root.addProperty("smelttime", (Number)this.smeltTime);
            }
        }
    }
}

