/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common.boat;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.bclib.items.boat.CustomBoatTypeOverride;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends Entity
implements CustomBoatTypeOverride {
    private BoatTypeOverride bcl_type = null;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> f_38285_;

    public BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void setCustomType(BoatTypeOverride type) {
        this.bcl_type = type;
        if (type == null) {
            this.f_19804_.m_135381_(f_38285_, (Object)Boat.Type.OAK.ordinal());
        } else {
            this.f_19804_.m_135381_(f_38285_, (Object)this.bcl_type.ordinal());
        }
    }

    @Override
    public BoatTypeOverride bcl_getCustomType() {
        this.bcl_type = BoatTypeOverride.byId((Integer)this.f_19804_.m_135370_(f_38285_));
        return this.bcl_type;
    }

    @Inject(method={"setVariant"}, at={@At(value="HEAD")}, cancellable=true)
    void bcl_setType(Boat.Type type, CallbackInfo ci) {
        if (this.bcl_type != null) {
            this.f_19804_.m_135381_(f_38285_, (Object)this.bcl_type.ordinal());
            ci.cancel();
        }
    }

    @Inject(method={"getVariant"}, at={@At(value="HEAD")}, cancellable=true)
    void bcl_getBoatType(CallbackInfoReturnable<Boat.Type> cir) {
        BoatTypeOverride type = BoatTypeOverride.byId((Integer)this.f_19804_.m_135370_(f_38285_));
        if (type != null) {
            this.bcl_type = type;
            cir.setReturnValue((Object)Boat.Type.OAK);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    void bcl_addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        BoatTypeOverride type = this.bcl_getCustomType();
        if (type != null) {
            compoundTag.m_128359_("cType", type.name());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    void bcl_readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.m_128441_("cType")) {
            this.setCustomType(BoatTypeOverride.byName(compoundTag.m_128461_("cType")));
        } else {
            this.setCustomType(null);
        }
    }

    @Inject(method={"getDropItem"}, at={@At(value="HEAD")}, cancellable=true)
    void bcl_getDropItem(CallbackInfoReturnable<Item> cir) {
        BoatItem boat;
        BoatTypeOverride type = this.bcl_getCustomType();
        if (type != null && (boat = type.getBoatItem()) != null) {
            cir.setReturnValue((Object)boat);
        }
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;kill()V", shift=At.Shift.AFTER)}, cancellable=true)
    void bcl_checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos, CallbackInfo ci) {
        BoatTypeOverride type = this.bcl_getCustomType();
        if (type != null && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            int i;
            for (i = 0; i < 3; ++i) {
                this.m_19998_((ItemLike)type.getPlanks());
            }
            for (i = 0; i < 2; ++i) {
                this.m_19998_((ItemLike)Items.f_42398_);
            }
            this.m_183634_();
            ci.cancel();
        }
    }
}

