/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.entry;

import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.ComplexMaterialEntry;
import org.betterx.bclib.registry.ItemRegistry;
import org.betterx.worlds.together.tag.v3.TagManager;

public class ItemEntry
extends ComplexMaterialEntry {
    final BiFunction<ComplexMaterial, Item.Properties, Item> initFunction;
    TagKey<Item>[] itemTags;

    public ItemEntry(String suffix, BiFunction<ComplexMaterial, Item.Properties, Item> initFunction) {
        super(suffix);
        this.initFunction = initFunction;
    }

    public ItemEntry setItemTags(TagKey<Item>[] itemTags) {
        this.itemTags = itemTags;
        return this;
    }

    public Item init(ComplexMaterial material, Item.Properties itemSettings, ItemRegistry registry) {
        ResourceLocation location = this.getLocation(material.getModID(), material.getBaseName());
        Item item = this.initFunction.apply(material, itemSettings);
        registry.register(location, item);
        if (this.itemTags != null) {
            TagManager.ITEMS.add(item, this.itemTags);
        }
        return item;
    }
}

