/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.bclib.models.RecordItemModelProvider;

public class CustomModelBakery {
    private final Map<ResourceLocation, UnbakedModel> models = Maps.newConcurrentMap();

    public UnbakedModel getBlockModel(ResourceLocation location) {
        return this.models.get(location);
    }

    public UnbakedModel getItemModel(ResourceLocation location) {
        return this.models.get(location);
    }

    public void loadCustomModels(ResourceManager resourceManager) {
        ((Stream)BuiltInRegistries.f_256975_.m_123024_().parallel()).filter(block -> block instanceof BlockModelProvider).forEach(block -> {
            ResourceLocation blockID = BuiltInRegistries.f_256975_.m_7981_(block);
            ResourceLocation storageID = new ResourceLocation(blockID.m_135827_(), "blockstates/" + blockID.m_135815_() + ".json");
            if (resourceManager.m_213713_(storageID).isEmpty()) {
                this.addBlockModel(blockID, (Block)block);
            }
            if (resourceManager.m_213713_(storageID = new ResourceLocation(blockID.m_135827_(), "models/item/" + blockID.m_135815_() + ".json")).isEmpty()) {
                this.addItemModel(blockID, (ItemModelProvider)block);
            }
        });
        ((Stream)BuiltInRegistries.f_257033_.m_123024_().parallel()).filter(item -> item instanceof ItemModelProvider || RecordItemModelProvider.has(item)).forEach(item -> {
            ItemModelProvider provider;
            ResourceLocation registryID = BuiltInRegistries.f_257033_.m_7981_(item);
            ResourceLocation storageID = new ResourceLocation(registryID.m_135827_(), "models/item/" + registryID.m_135815_() + ".json");
            ItemModelProvider itemModelProvider = provider = item instanceof ItemModelProvider ? (ItemModelProvider)item : RecordItemModelProvider.get(item);
            if (resourceManager.m_213713_(storageID).isEmpty()) {
                this.addItemModel(registryID, provider);
            }
        });
    }

    private void addBlockModel(ResourceLocation blockID, Block block) {
        BlockModelProvider provider = (BlockModelProvider)block;
        ImmutableList states = block.m_49965_().m_61056_();
        BlockState defaultState = block.m_49966_();
        ModelResourceLocation defaultStateID = BlockModelShaper.m_110889_((ResourceLocation)blockID, (BlockState)defaultState);
        UnbakedModel defaultModel = provider.getModelVariant((ResourceLocation)defaultStateID, defaultState, this.models);
        if (defaultModel instanceof MultiPart) {
            states.forEach(blockState -> {
                ModelResourceLocation stateID = BlockModelShaper.m_110889_((ResourceLocation)blockID, (BlockState)blockState);
                this.models.put((ResourceLocation)stateID, defaultModel);
            });
        } else {
            states.forEach(arg_0 -> this.lambda$addBlockModel$5(blockID, (ResourceLocation)defaultStateID, defaultModel, provider, arg_0));
        }
    }

    private void addItemModel(ResourceLocation itemID, ItemModelProvider provider) {
        ModelResourceLocation modelLocation = new ModelResourceLocation(itemID.m_135827_(), itemID.m_135815_(), "inventory");
        if (this.models.containsKey(modelLocation)) {
            return;
        }
        BlockModel model = provider.getItemModel((ResourceLocation)modelLocation);
        this.models.put((ResourceLocation)modelLocation, (UnbakedModel)model);
    }

    private /* synthetic */ void lambda$addBlockModel$5(ResourceLocation blockID, ResourceLocation defaultStateID, UnbakedModel defaultModel, BlockModelProvider provider, BlockState blockState) {
        ModelResourceLocation stateID = BlockModelShaper.m_110889_((ResourceLocation)blockID, (BlockState)blockState);
        UnbakedModel model = stateID.equals((Object)defaultStateID) ? defaultModel : provider.getModelVariant((ResourceLocation)stateID, blockState, this.models);
        this.models.put((ResourceLocation)stateID, model);
    }
}

