/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;

public abstract class StalactiteBlock
extends BaseBlockNotFull
implements SimpleWaterloggedBlock,
LiquidBlockContainer,
RenderLayerProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty IS_FLOOR = BlockProperties.IS_FLOOR;
    public static final IntegerProperty SIZE = BlockProperties.SIZE;
    private static final VoxelShape[] SHAPES;

    public StalactiteBlock(Block source) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_());
    }

    public StalactiteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(0))).m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{WATERLOGGED, IS_FLOOR, SIZE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPES[(Integer)state.m_61143_((Property)SIZE)];
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean water;
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction dir = ctx.m_43719_();
        boolean bl = water = world.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        if (dir == Direction.DOWN) {
            if (this.isThis((LevelReader)world, pos.m_7494_()) || StalactiteBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN)) {
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            if (this.isThis((LevelReader)world, pos.m_7495_()) || StalactiteBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP)) {
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            return null;
        }
        if (this.isThis((LevelReader)world, pos.m_7495_()) || StalactiteBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        if (this.isThis((LevelReader)world, pos.m_7494_()) || StalactiteBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        block6: {
            BlockPos.MutableBlockPos mut;
            boolean hasUp;
            block8: {
                boolean hasDown;
                block7: {
                    int i;
                    hasUp = this.isThis((LevelReader)world, pos.m_7494_());
                    hasDown = this.isThis((LevelReader)world, pos.m_7495_());
                    mut = new BlockPos.MutableBlockPos();
                    if (!hasUp || !hasDown) break block7;
                    boolean floor = (Boolean)state.m_61143_((Property)IS_FLOOR);
                    BlockPos second = floor ? pos.m_7494_() : pos.m_7495_();
                    BlockState bState = world.m_8055_(second);
                    world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1))).m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(floor)));
                    world.m_46597_(second, (BlockState)((BlockState)bState.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1))).m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(!floor)));
                    bState = state;
                    int startSize = floor ? 1 : 2;
                    mut.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                    for (i = 0; i < 8 && this.isThis(bState); ++i) {
                        world.m_46597_((BlockPos)mut, (BlockState)((BlockState)bState.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(Math.min(7, startSize + i)))).m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false)));
                        mut.m_142448_(mut.m_123342_() + 1);
                        bState = world.m_8055_((BlockPos)mut);
                    }
                    bState = state;
                    startSize = floor ? 2 : 1;
                    mut.m_122178_(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
                    for (i = 0; i < 8 && this.isThis(bState); ++i) {
                        world.m_46597_((BlockPos)mut, (BlockState)((BlockState)bState.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(Math.min(7, startSize + i)))).m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true)));
                        mut.m_142448_(mut.m_123342_() - 1);
                        bState = world.m_8055_((BlockPos)mut);
                    }
                    break block6;
                }
                if (!hasDown) break block8;
                mut.m_142451_(pos.m_123341_());
                mut.m_142443_(pos.m_123343_());
                for (int i = 1; i < 8; ++i) {
                    BlockState state2;
                    int size;
                    mut.m_142448_(pos.m_123342_() - i);
                    if (this.isThis((LevelReader)world, (BlockPos)mut) && (size = ((Integer)(state2 = world.m_8055_((BlockPos)mut)).m_61143_((Property)SIZE)).intValue()) < i) {
                        world.m_46597_((BlockPos)mut, (BlockState)((BlockState)state2.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(i))).m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true)));
                        continue;
                    }
                    break block6;
                }
                break block6;
            }
            if (!hasUp) break block6;
            mut.m_142451_(pos.m_123341_());
            mut.m_142443_(pos.m_123343_());
            for (int i = 1; i < 8; ++i) {
                BlockState state2;
                int size;
                mut.m_142448_(pos.m_123342_() + i);
                if (this.isThis((LevelReader)world, (BlockPos)mut) && (size = ((Integer)(state2 = world.m_8055_((BlockPos)mut)).m_61143_((Property)SIZE)).intValue()) < i) {
                    world.m_46597_((BlockPos)mut, (BlockState)((BlockState)state2.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(i))).m_61124_((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                break;
            }
        }
    }

    private boolean isThis(LevelReader world, BlockPos pos) {
        return this.isThis(world.m_8055_(pos));
    }

    private boolean isThis(BlockState state) {
        return state.m_60734_() instanceof StalactiteBlock;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        int size = (Integer)state.m_61143_((Property)SIZE);
        return this.checkUp((BlockGetter)world, pos, size) || this.checkDown((BlockGetter)world, pos, size);
    }

    private boolean checkUp(BlockGetter world, BlockPos pos, int size) {
        BlockPos p = pos.m_7494_();
        BlockState state = world.m_8055_(p);
        return this.isThis(state) && (Integer)state.m_61143_((Property)SIZE) >= size || state.m_60838_(world, p);
    }

    private boolean checkDown(BlockGetter world, BlockPos pos, int size) {
        BlockPos p = pos.m_7495_();
        BlockState state = world.m_8055_(p);
        return this.isThis(state) && (Integer)state.m_61143_((Property)SIZE) >= size || state.m_60838_(world, p);
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    static {
        float end = 0.25f;
        float start = 0.625f;
        SHAPES = new VoxelShape[8];
        for (int i = 0; i < 8; ++i) {
            int side = Mth.m_14143_((float)(Mth.m_14179_((float)((float)i / 7.0f), (float)start, (float)end) * 8.0f + 0.5f));
            StalactiteBlock.SHAPES[i] = StalactiteBlock.m_49796_((double)side, (double)0.0, (double)side, (double)(16 - side), (double)16.0, (double)(16 - side));
        }
    }

    public static class Stone
    extends StalactiteBlock
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }

        public Stone(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

