/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.api.v3.levelgen.features.BCLConfigureFeature;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;

public class FeatureSaplingBlock<F extends Feature<FC>, FC extends FeatureConfiguration>
extends SaplingBlock
implements RenderLayerProvider,
BlockModelProvider,
DropSelfLootProvider<FeatureSaplingBlock> {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private final FeatureSupplier<F, FC> feature;

    public FeatureSaplingBlock(FeatureSupplier<F, FC> featureSupplier) {
        this(0, featureSupplier);
    }

    public FeatureSaplingBlock(int light, FeatureSupplier<F, FC> featureSupplier) {
        this(BehaviourBuilders.createPlant().m_60977_().m_60910_().m_60953_(state -> light).m_60918_(SoundType.f_56740_), featureSupplier);
    }

    public FeatureSaplingBlock(BlockBehaviour.Properties properties, FeatureSupplier<F, FC> featureSupplier) {
        super(null, properties);
        this.feature = featureSupplier;
    }

    protected BCLConfigureFeature<F, FC> getConfiguredFeature(BlockState state) {
        return this.feature != null ? this.feature.get(state) : null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(16) == 0;
    }

    public void m_222000_(ServerLevel world, BlockPos pos, BlockState blockState, RandomSource random) {
        if ((Integer)blockState.m_61143_((Property)f_55973_) == 0) {
            world.m_7731_(pos, (BlockState)blockState.m_61122_((Property)f_55973_), 4);
        } else {
            BCLConfigureFeature<F, FC> conf = this.getConfiguredFeature(blockState);
            this.growFeature(conf, world, pos, blockState, random);
        }
    }

    protected boolean growFeature(BCLConfigureFeature<F, FC> feature, ServerLevel serverLevel, BlockPos blockPos, BlockState originalBlockState, RandomSource randomSource) {
        if (feature == null) {
            return false;
        }
        BlockState emptyState = serverLevel.m_6425_(blockPos).m_76188_();
        serverLevel.m_7731_(blockPos, emptyState, 4);
        if (feature.placeInWorld(serverLevel, blockPos, randomSource)) {
            if (serverLevel.m_8055_(blockPos) == emptyState) {
                serverLevel.m_7260_(blockPos, originalBlockState, emptyState, 2);
            }
            return true;
        }
        serverLevel.m_7731_(blockPos, originalBlockState, 4);
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.m_213897_(state, world, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (this.m_214167_((Level)world, random, pos, state)) {
            this.m_214148_(world, random, pos, state);
        }
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @FunctionalInterface
    public static interface FeatureSupplier<F extends Feature<FC>, FC extends FeatureConfiguration> {
        public BCLConfigureFeature<F, FC> get(BlockState var1);
    }
}

