/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BaseTrapdoorBlock
extends TrapDoorBlock
implements RenderLayerProvider,
BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseTrapdoorBlock> {
    protected BaseTrapdoorBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(properties, type);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13036_);
        itemTags.add((TagKey<Item>)ItemTags.f_13144_);
    }

    public static BaseTrapdoorBlock from(Block source, BlockSetType type, boolean flammable) {
        return BehaviourHelper.from(source, type, (s, t) -> new Wood((Block)s, (BlockSetType)t, flammable), Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseTrapdoorBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type, boolean flammable) {
            this(BehaviourBuilders.createTrapDoor(source.m_284356_(), flammable).m_60918_(SoundType.f_56736_), type);
        }

        public Wood(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13102_);
            itemTags.add((TagKey<Item>)ItemTags.f_13178_);
        }
    }

    public static class Metal
    extends BaseTrapdoorBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            this(BehaviourBuilders.createTrapDoor(source.m_284356_(), false).m_60918_(SoundType.f_56743_), type);
        }

        public Metal(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }

    public static class Stone
    extends BaseTrapdoorBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            this(BehaviourBuilders.createTrapDoor(source.m_284356_(), false).m_60918_(SoundType.f_56742_), type);
        }

        public Stone(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }
}

