/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.client.sound.BlockSounds;
import org.betterx.worlds.together.tag.v3.MineableTags;
import org.betterx.worlds.together.tag.v3.TagManager;

public class BaseTerrainBlock
extends BaseBlock {
    private final Block baseBlock;
    private Block pathBlock;

    public BaseTerrainBlock(Block baseBlock, MapColor color) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock).m_284180_(color).m_60918_(BlockSounds.TERRAIN_SOUND).m_60977_());
        this.baseBlock = baseBlock;
    }

    public void setPathBlock(Block roadBlock) {
        this.pathBlock = roadBlock;
    }

    public Block getBaseBlock() {
        return this.baseBlock;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.pathBlock != null && TagManager.isToolWithMineableTag(player.m_21205_(), MineableTags.SHOVEL)) {
            world.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                world.m_46597_(pos, this.pathBlock.m_49966_());
                if (!player.m_7500_()) {
                    player.m_21205_().m_220157_(1, world.f_46441_, (ServerPlayer)player);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (tool != null && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return Collections.singletonList(new ItemStack((ItemLike)this));
        }
        return Collections.singletonList(new ItemStack((ItemLike)this.getBaseBlock()));
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(16) == 0 && !this.canStay(state, (LevelReader)world, pos)) {
            world.m_46597_(pos, this.getBaseBlock().m_49966_());
        }
    }

    public boolean canStay(BlockState state, LevelReader worldView, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = worldView.m_8055_(blockPos);
        if (blockState.m_60713_(Blocks.f_50125_) && (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockState.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LightEngine.m_284282_((BlockGetter)worldView, (BlockState)state, (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.m_60739_((BlockGetter)worldView, blockPos));
        return i < 5;
    }
}

