/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BaseStairsBlock
extends StairBlock
implements BlockModelProvider,
CustomItemProvider,
TagProvider,
DropSelfLootProvider<BaseStairsBlock> {
    private final Block parent;
    public final boolean fireproof;

    protected BaseStairsBlock(Block source, boolean fireproof) {
        super(source.m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)source));
        this.parent = source;
        this.fireproof = fireproof;
    }

    @Override
    public BlockItem getCustomItem(ResourceLocation blockID, Item.Properties settings) {
        if (this.fireproof) {
            settings = settings.m_41486_();
        }
        return new BlockItem((Block)this, settings);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13030_);
        itemTags.add((TagKey<Item>)ItemTags.f_13138_);
    }

    public static BaseStairsBlock from(Block source, boolean flammable) {
        return BehaviourHelper.from(source, block -> new Wood((Block)block, flammable), block -> new Stone((Block)block, !flammable), block -> new Metal((Block)block, !flammable), block -> new Obsidian((Block)block, !flammable), null);
    }

    public static class Obsidian
    extends BaseStairsBlock
    implements BehaviourObsidian {
        public Obsidian(Block source) {
            this(source, true);
        }

        public Obsidian(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Metal
    extends BaseStairsBlock
    implements BehaviourMetal {
        public Metal(Block source) {
            this(source, true);
        }

        public Metal(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Stone
    extends BaseStairsBlock
    implements BehaviourStone {
        public Stone(Block source) {
            this(source, true);
        }

        public Stone(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Wood
    extends BaseStairsBlock
    implements BehaviourWood {
        public Wood(Block source) {
            this(source, false);
        }

        public Wood(Block source, boolean fireproof) {
            super(source, fireproof);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13096_);
            itemTags.add((TagKey<Item>)ItemTags.f_13174_);
        }
    }
}

