/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BasePressurePlateBlock
extends PressurePlateBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BasePressurePlateBlock> {
    private final Block parent;

    protected BasePressurePlateBlock(PressurePlateBlock.Sensitivity rule, Block source, BlockSetType type) {
        super(rule, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60910_().m_60955_().m_60978_(0.5f), type);
        this.parent = source;
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13099_);
    }

    public static BasePressurePlateBlock from(Block source, BlockSetType type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BasePressurePlateBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            super(PressurePlateBlock.Sensitivity.MOBS, source, type);
        }
    }

    public static class Stone
    extends BasePressurePlateBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            super(PressurePlateBlock.Sensitivity.MOBS, source, type);
        }
    }

    public static class Wood
    extends BasePressurePlateBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type) {
            super(PressurePlateBlock.Sensitivity.EVERYTHING, source, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13100_);
            itemTags.add((TagKey<Item>)ItemTags.f_13177_);
        }
    }
}

