/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.LootUtil;

public abstract class BasePlantBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
BonemealableBlock {
    private static final VoxelShape SHAPE = BasePlantBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);

    protected BasePlantBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected abstract boolean isTerrain(BlockState var1);

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.m_60824_(view, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState down = level.m_8055_(pos.m_7495_());
        return this.isTerrain(down);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, state, tool) || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return Lists.newArrayList();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        ItemEntity item = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)this));
        level.m_7967_((Entity)item);
    }
}

