/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourOre;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.util.LootUtil;
import org.betterx.bclib.util.MHelper;
import org.betterx.worlds.together.tag.v3.MineableTags;

public class BaseOreBlock
extends DropExperienceBlock
implements BlockModelProvider,
TagProvider,
BehaviourOre {
    private final Supplier<Item> dropItem;
    private final int minCount;
    private final int maxCount;
    private final int miningLevel;

    public BaseOreBlock(Supplier<Item> drop, int minCount, int maxCount, int experience) {
        this(drop, minCount, maxCount, experience, 0);
    }

    public BaseOreBlock(Supplier<Item> drop, int minCount, int maxCount, int experience, int miningLevel) {
        this(BehaviourBuilders.createStone(MapColor.f_283761_).m_60999_().m_155954_(3.0f).m_155956_(9.0f).m_60918_(SoundType.f_56742_), drop, minCount, maxCount, experience, miningLevel);
    }

    public BaseOreBlock(BlockBehaviour.Properties properties, Supplier<Item> drop, int minCount, int maxCount, int experience) {
        this(properties, drop, minCount, maxCount, experience, 0);
    }

    public BaseOreBlock(BlockBehaviour.Properties properties, Supplier<Item> drop, int minCount, int maxCount, int experience, int miningLevel) {
        super(properties, (IntProvider)UniformInt.m_146622_((int)(experience > 0 ? 1 : 0), (int)experience));
        this.dropItem = drop;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.miningLevel = miningLevel;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return LootUtil.getDrops((BlockBehaviour)this, state, builder).orElseGet(() -> BaseOreBlock.getDroppedItems((ItemLike)this, this.dropItem.get(), this.maxCount, this.minCount, this.miningLevel, state, builder));
    }

    public static List<ItemStack> getDroppedItems(ItemLike block, Item dropItem, int maxCount, int minCount, int miningLevel, BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (tool != null && tool.m_41735_(state) && dropItem != null) {
            boolean canMine = miningLevel == 0;
            Item item = tool.m_41720_();
            if (item instanceof TieredItem) {
                TieredItem tired = (TieredItem)item;
                boolean bl = canMine = tired.m_43314_().m_6604_() >= miningLevel;
            }
            if (canMine) {
                int count;
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
                    return Collections.singletonList(new ItemStack(block));
                }
                int enchantment = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
                if (enchantment > 0) {
                    int max;
                    int min = Mth.m_14045_((int)(minCount + enchantment), (int)minCount, (int)maxCount);
                    if (min == (max = maxCount + enchantment / Enchantments.f_44987_.m_6586_())) {
                        return Collections.singletonList(new ItemStack((ItemLike)dropItem, max));
                    }
                    count = MHelper.randRange(min, max, MHelper.RANDOM_SOURCE);
                } else {
                    count = MHelper.randRange(minCount, maxCount, MHelper.RANDOM_SOURCE);
                }
                return Collections.singletonList(new ItemStack((ItemLike)dropItem, count));
            }
        }
        return Collections.emptyList();
    }

    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        if (this.miningLevel == Tiers.STONE.m_6604_()) {
            blockTags.add((TagKey<Block>)BlockTags.f_144286_);
        } else if (this.miningLevel == Tiers.IRON.m_6604_()) {
            blockTags.add((TagKey<Block>)BlockTags.f_144285_);
        } else if (this.miningLevel == Tiers.DIAMOND.m_6604_()) {
            blockTags.add((TagKey<Block>)BlockTags.f_144284_);
        } else if (this.miningLevel == Tiers.NETHERITE.m_6604_()) {
            blockTags.add(MineableTags.NEEDS_NETHERITE_TOOL);
        }
    }
}

