/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourLeaves;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.util.MHelper;

public class BaseLeavesBlock
extends LeavesBlock
implements BlockModelProvider,
RenderLayerProvider,
BehaviourLeaves {
    protected final Block sapling;

    public BaseLeavesBlock(Block sapling, BlockBehaviour.Properties properties) {
        super(properties);
        this.sapling = sapling;
    }

    @Deprecated(forRemoval=true)
    public BaseLeavesBlock(Block sapling, MapColor color, Consumer<BlockBehaviour.Properties> customizeProperties) {
        super(BaseBlock.acceptAndReturn(customizeProperties, BehaviourBuilders.createLeaves(color, true)));
        this.sapling = sapling;
    }

    @Deprecated(forRemoval=true)
    public BaseLeavesBlock(Block sapling, MapColor color, int light, Consumer<BlockBehaviour.Properties> customizeProperties) {
        super(BaseBlock.acceptAndReturn(customizeProperties, BehaviourBuilders.createLeaves(color, true).m_60953_(state -> light)));
        this.sapling = sapling;
    }

    @Deprecated(forRemoval=true)
    public BaseLeavesBlock(Block sapling, MapColor color) {
        super(BehaviourBuilders.createLeaves(color, true));
        this.sapling = sapling;
    }

    @Deprecated(forRemoval=true)
    public BaseLeavesBlock(Block sapling, MapColor color, int light) {
        super(BehaviourBuilders.createLeaves(color, true).m_60953_(state -> light));
        this.sapling = sapling;
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return BaseLeavesBlock.getLeaveDrops((ItemLike)this, this.sapling, builder, 16, 16);
    }

    public static List<ItemStack> getLeaveDrops(ItemLike leaveBlock, Block sapling, LootParams.Builder builder, int fortuneRate, int dropRate) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (tool != null) {
            if (tool != null && BaseShearsItem.isShear(tool) || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
                return Collections.singletonList(new ItemStack(leaveBlock));
            }
            int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
            if (MHelper.RANDOM.nextInt(fortuneRate) <= fortune) {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)sapling)});
            }
            return Lists.newArrayList();
        }
        return MHelper.RANDOM.nextInt(dropRate) == 0 ? Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)sapling)}) : Lists.newArrayList();
    }

    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    public float compostingChance() {
        return 0.3f;
    }
}

