/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BaseDoorBlock
extends DoorBlock
implements RenderLayerProvider,
BlockModelProvider,
TagProvider {
    protected BaseDoorBlock(Block source, BlockSetType type) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60913_(3.0f, 3.0f).m_60955_(), type);
    }

    protected BaseDoorBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(properties, type);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }
        return Collections.emptyList();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    protected DoorType getDoorType(BlockState blockState) {
        boolean isHinge = this.isHinge((DoorHingeSide)blockState.m_61143_((Property)f_52728_), (Boolean)blockState.m_61143_((Property)f_52727_));
        switch ((DoubleBlockHalf)blockState.m_61143_((Property)f_52730_)) {
            case UPPER: {
                return isHinge ? DoorType.TOP_HINGE : DoorType.TOP;
            }
            case LOWER: {
                return isHinge ? DoorType.BOTTOM_HINGE : DoorType.BOTTOM;
            }
        }
        return DoorType.BOTTOM;
    }

    private boolean isHinge(DoorHingeSide hingeSide, boolean open) {
        boolean isHinge = hingeSide == DoorHingeSide.RIGHT;
        return isHinge && !open || !isHinge && open;
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13103_);
        itemTags.add((TagKey<Item>)ItemTags.f_13179_);
    }

    public static BaseDoorBlock from(Block source, BlockSetType type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    protected static enum DoorType implements StringRepresentable
    {
        BOTTOM_HINGE("bottom_hinge"),
        TOP_HINGE("top_hinge"),
        BOTTOM("bottom"),
        TOP("top");

        private final String name;

        private DoorType(String name) {
            this.name = name;
        }

        public boolean isHinge() {
            return this == BOTTOM_HINGE || this == TOP_HINGE;
        }

        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static class Stone
    extends BaseDoorBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            super(source, type);
        }

        public Stone(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }

    public static class Metal
    extends BaseDoorBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            super(source, type);
        }

        public Metal(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }

    public static class Wood
    extends BaseDoorBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type) {
            super(source, type);
        }

        public Wood(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13095_);
            itemTags.add((TagKey<Item>)ItemTags.f_13173_);
        }
    }
}

