/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;

public abstract class BaseChestBlock
extends ChestBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseChestBlock> {
    private final Block parent;

    protected BaseChestBlock(Block source) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_(), () -> BaseBlockEntities.CHEST);
        this.parent = source;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return BaseBlockEntities.CHEST.m_155264_(blockPos, blockState);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add(CommonBlockTags.CHEST);
        itemTags.add(CommonItemTags.CHEST);
    }

    public static BaseChestBlock from(Block source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseChestBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add(CommonBlockTags.WOODEN_CHEST);
            itemTags.add(CommonItemTags.WOODEN_CHEST);
        }
    }
}

