/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BaseButtonBlock
extends ButtonBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseButtonBlock> {
    private final Block parent;

    protected BaseButtonBlock(Block parent, BlockBehaviour.Properties properties, boolean sensitive, BlockSetType type) {
        this(parent, properties, 30, sensitive, type);
    }

    protected BaseButtonBlock(Block parent, BlockBehaviour.Properties properties, int ticksToStayPressed, boolean sensitive, BlockSetType type) {
        super(properties.m_60910_(), type, ticksToStayPressed, sensitive);
        this.parent = parent;
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13093_);
        itemTags.add((TagKey<Item>)ItemTags.f_13171_);
    }

    public static BaseButtonBlock from(Block source, BlockSetType type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseButtonBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type) {
            super(source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60913_(0.5f, 0.5f).m_60955_(), true, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13092_);
            itemTags.add((TagKey<Item>)ItemTags.f_13170_);
        }
    }

    public static class Stone
    extends BaseButtonBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            super(source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_(), false, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_279568_);
            itemTags.add((TagKey<Item>)ItemTags.f_279629_);
        }
    }

    public static class Metal
    extends BaseButtonBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            super(source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_(), false, type);
        }
    }
}

