/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public abstract class BaseBookshelfBlock
extends BaseBlock
implements TagProvider {
    protected BaseBookshelfBlock(Block source) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source));
    }

    protected BaseBookshelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        int silk;
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (tool != null && (silk = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool)) > 0) {
            return Collections.singletonList(new ItemStack((ItemLike)this));
        }
        return Collections.singletonList(new ItemStack((ItemLike)Items.f_42517_, 3));
    }

    protected ResourceLocation replacePath(ResourceLocation blockId) {
        String newPath = blockId.m_135815_().replace("_bookshelf", "");
        return new ResourceLocation(blockId.m_135827_(), newPath);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add(CommonBlockTags.BOOKSHELVES);
    }

    public static BaseBookshelfBlock from(Block source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseBookshelfBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }

        public Wood(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }

    public static class VanillaWood
    extends Wood {
        public VanillaWood(Block source) {
            super(source);
        }
    }
}

