/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blockentities.BaseBarrelBlockEntity;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;

public abstract class BaseBarrelBlock
extends BarrelBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseBarrelBlock> {
    BaseBarrelBlock(Block source) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_());
    }

    BaseBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return BaseBlockEntities.BARREL.m_155264_(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BaseBarrelBlockEntity) {
            player.m_5893_((MenuProvider)((BaseBarrelBlockEntity)blockEntity));
            player.m_36220_(Stats.f_12971_);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BaseBarrelBlockEntity) {
            ((BaseBarrelBlockEntity)blockEntity).recheckOpen();
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof BaseBarrelBlockEntity) {
            ((BaseBarrelBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add(CommonBlockTags.BARREL);
        itemTags.add(CommonItemTags.BARREL);
    }

    public static BaseBarrelBlock from(Block source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseBarrelBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }

        public Wood(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add(CommonBlockTags.WOODEN_BARREL);
            itemTags.add(CommonItemTags.WOODEN_BARREL);
        }
    }
}

