/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.items.BaseAnvilItem;
import org.betterx.bclib.util.LootUtil;
import org.jetbrains.annotations.ApiStatus;

public abstract class BaseAnvilBlock
extends AnvilBlock
implements AddMineablePickaxe,
BlockModelProvider,
CustomItemProvider {
    public static final IntegerProperty DESTRUCTION = BlockProperties.DESTRUCTION;
    public IntegerProperty durability;

    public BaseAnvilBlock(MapColor color) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_284180_(color));
    }

    public BaseAnvilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        this.durability = this.getMaxDurability() != 3 ? IntegerProperty.m_61631_((String)"durability", (int)0, (int)this.getMaxDurability()) : BlockProperties.DEFAULT_ANVIL_DURABILITY;
        builder.m_61104_(new Property[]{DESTRUCTION, this.durability});
    }

    @Override
    public BlockItem getCustomItem(ResourceLocation blockID, Item.Properties settings) {
        return new BaseAnvilItem((Block)this, settings);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        int destruction = (Integer)state.m_61143_((Property)DESTRUCTION);
        int durability = (Integer)state.m_61143_((Property)this.getDurabilityProp());
        int value = destruction * this.getMaxDurability() + durability;
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, state, tool)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            itemStack.m_41784_().m_128405_("destruction", value);
            return Lists.newArrayList((Object[])new ItemStack[]{itemStack});
        }
        return Collections.emptyList();
    }

    public IntegerProperty getDurabilityProp() {
        return this.durability;
    }

    public int getMaxDurability() {
        return 5;
    }

    public BlockState damageAnvilUse(BlockState state, RandomSource random) {
        IntegerProperty durability = this.getDurabilityProp();
        int value = (Integer)state.m_61143_((Property)durability);
        if (value < this.getMaxDurability()) {
            return (BlockState)state.m_61124_((Property)durability, (Comparable)Integer.valueOf(value + 1));
        }
        value = (Integer)state.m_61143_((Property)DESTRUCTION);
        return value < 2 ? (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION, (Comparable)Integer.valueOf(value + 1))).m_61124_((Property)durability, (Comparable)Integer.valueOf(0)) : null;
    }

    public BlockState damageAnvilFall(BlockState state) {
        int destruction = (Integer)state.m_61143_((Property)DESTRUCTION);
        return destruction < 2 ? (BlockState)state.m_61124_((Property)DESTRUCTION, (Comparable)Integer.valueOf(destruction + 1)) : null;
    }

    @ApiStatus.Internal
    public static void destroyWhenNull(Level level, BlockPos blockPos, BlockState damaged) {
        if (damaged == null) {
            level.m_7471_(blockPos, false);
            level.m_46796_(1029, blockPos, 0);
        } else {
            level.m_7731_(blockPos, damaged, 2);
            level.m_46796_(1030, blockPos, 0);
        }
    }
}

