/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.bclib.api.v3.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.noise.Noises;

public class NoiseFilter
extends PlacementFilter {
    public static final Codec<NoiseFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256865_).fieldOf("noise").forGetter(o -> o.noise), (App)Codec.DOUBLE.fieldOf("min_noise_level").forGetter(o -> o.minNoiseLevel), (App)Codec.DOUBLE.fieldOf("max_noise_level").orElse((Object)Double.MAX_VALUE).forGetter(o -> o.maxNoiseLevel), (App)Codec.FLOAT.fieldOf("scale_xz").orElse((Object)Float.valueOf(1.0f)).forGetter(o -> Float.valueOf(o.scaleXZ)), (App)Codec.FLOAT.fieldOf("scale_y").orElse((Object)Float.valueOf(1.0f)).forGetter(o -> Float.valueOf(o.scaleY))).apply((Applicative)instance, NoiseFilter::new));
    private final ResourceKey<NormalNoise.NoiseParameters> noise;
    private final double minNoiseLevel;
    private final double maxNoiseLevel;
    private final float scaleXZ;
    private final float scaleY;

    public NoiseFilter(ResourceKey<NormalNoise.NoiseParameters> noise, double minNoiseLevel, double maxNoiseLevel, float scaleXZ, float scaleY) {
        this.noise = noise;
        this.minNoiseLevel = minNoiseLevel;
        this.maxNoiseLevel = maxNoiseLevel;
        this.scaleXZ = scaleXZ;
        this.scaleY = scaleY;
    }

    protected boolean m_213917_(PlacementContext ctx, RandomSource random, BlockPos pos) {
        NormalNoise normalNoise = Noises.getOrCreateNoise(ctx.m_191831_().m_9598_(), random, this.noise);
        double v = normalNoise.m_75380_((double)((float)pos.m_123341_() * this.scaleXZ), (double)((float)pos.m_123342_() * this.scaleY), (double)((float)pos.m_123343_() * this.scaleXZ));
        return v > this.minNoiseLevel && v < this.maxNoiseLevel;
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifiers.NOISE_FILTER;
    }
}

