/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.betterx.bclib.api.v3.levelgen.features.config.PlaceBlockFeatureConfig;
import org.betterx.bclib.util.BlocksHelper;

public class PlaceFacingBlockConfig
extends PlaceBlockFeatureConfig {
    public static final Codec<PlaceFacingBlockConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(PlaceFacingBlockConfig.blockStateCodec(), (App)ExtraCodecs.m_144637_((Codec)Direction.f_175356_.listOf()).fieldOf("dir").orElse(List.of(Direction.NORTH)).forGetter(a -> a.directions)).apply((Applicative)instance, PlaceFacingBlockConfig::new));
    public static final List<Direction> HORIZONTAL = List.of(Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH);
    public static final List<Direction> VERTICAL = List.of(Direction.UP, Direction.DOWN);
    public static final List<Direction> ALL = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN);
    private final List<Direction> directions;

    public PlaceFacingBlockConfig(Block block, List<Direction> dir) {
        this(block.m_49966_(), dir);
    }

    public PlaceFacingBlockConfig(BlockState state, List<Direction> dir) {
        this((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state), dir);
    }

    public PlaceFacingBlockConfig(List<BlockState> states, List<Direction> dir) {
        this(PlaceFacingBlockConfig.buildWeightedList(states), dir);
    }

    public PlaceFacingBlockConfig(SimpleWeightedRandomList<BlockState> blocks, List<Direction> dir) {
        this((BlockStateProvider)new WeightedStateProvider(blocks), dir);
    }

    public PlaceFacingBlockConfig(BlockStateProvider blocks, List<Direction> dir) {
        super(blocks);
        this.directions = dir;
    }

    @Override
    public boolean placeBlock(FeaturePlaceContext<? extends PlaceBlockFeatureConfig> ctx, WorldGenLevel level, BlockPos pos, BlockState targetState) {
        for (Direction dir : this.directions) {
            BlockPos testPos = pos.m_121945_(dir);
            BlockState lookupState = (BlockState)targetState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir);
            if (!level.m_8055_(testPos).m_60795_() || !lookupState.m_60710_((LevelReader)level, testPos)) continue;
            lookupState.m_60710_((LevelReader)level, testPos);
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, testPos, lookupState);
            return true;
        }
        return false;
    }
}

