/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.BCLPlacedFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;

public class BCLConfigureFeature<F extends Feature<FC>, FC extends FeatureConfiguration> {
    private static final Map<Holder<ConfiguredFeature<?, ?>>, BCLConfigureFeature<?, ?>> KNOWN = new HashMap();
    public final ResourceLocation id;
    public final Holder<ConfiguredFeature<FC, F>> configuredFeature;
    public final boolean registered;

    BCLConfigureFeature(ResourceLocation id, Holder<ConfiguredFeature<FC, F>> configuredFeature, boolean registered) {
        this.id = id;
        this.configuredFeature = configuredFeature;
        this.registered = registered;
    }

    public F getFeature() {
        return (F)((ConfiguredFeature)this.configuredFeature.m_203334_()).f_65377_();
    }

    public FC getConfiguration() {
        return (FC)((ConfiguredFeature)this.configuredFeature.m_203334_()).f_65378_();
    }

    public BCLPlacedFeatureBuilder<F, FC> place() {
        return this.place(this.id);
    }

    public BCLPlacedFeatureBuilder<F, FC> place(ResourceLocation id) {
        return BCLPlacedFeatureBuilder.place(id, this);
    }

    static <F extends Feature<FC>, FC extends FeatureConfiguration> BCLConfigureFeature<F, FC> create(Holder<ConfiguredFeature<FC, F>> registeredFeature) {
        return KNOWN.computeIfAbsent(registeredFeature, holder -> new BCLConfigureFeature(((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_(), registeredFeature, false));
    }

    public boolean placeInWorld(ServerLevel level, BlockPos pos, RandomSource random) {
        return this.placeInWorld(level, pos, random, false);
    }

    public boolean placeInWorld(ServerLevel level, BlockPos pos, RandomSource random, boolean unchanged) {
        return BCLConfigureFeature.placeUnboundInWorld(this.getFeature(), this.getConfiguration(), level, pos, random, unchanged);
    }

    private static boolean placeUnboundInWorld(Feature<?> feature, FeatureConfiguration config, ServerLevel level, BlockPos pos, RandomSource random, boolean asIs) {
        if (!asIs) {
            if (config instanceof RandomPatchConfiguration) {
                RandomPatchConfiguration rnd = (RandomPatchConfiguration)config;
                ConfiguredFeature configured = (ConfiguredFeature)((PlacedFeature)rnd.f_191304_().m_203334_()).f_191775_().m_203334_();
                feature = configured.f_65377_();
                config = configured.f_65378_();
            }
            if (feature instanceof UserGrowableFeature) {
                UserGrowableFeature growable = (UserGrowableFeature)feature;
                return growable.grow((ServerLevelAccessor)level, pos, random, config);
            }
        }
        FeaturePlaceContext context = new FeaturePlaceContext(Optional.empty(), (WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos, config);
        return feature.m_142674_(context);
    }

    public static boolean placeInWorld(Feature<NoneFeatureConfiguration> feature, ServerLevel level, BlockPos pos, RandomSource random) {
        return BCLConfigureFeature.placeUnboundInWorld(feature, (FeatureConfiguration)FeatureConfiguration.f_67737_, level, pos, random, true);
    }

    public static <FC extends FeatureConfiguration> boolean placeInWorld(Feature<FC> feature, FC config, ServerLevel level, BlockPos pos, RandomSource random) {
        return BCLConfigureFeature.placeUnboundInWorld(feature, config, level, pos, random, true);
    }

    public BCLConfigureFeature<F, FC> register(BootstapContext<ConfiguredFeature<?, ?>> bootstrapContext) {
        return this;
    }

    public static class Unregistered<F extends Feature<FC>, FC extends FeatureConfiguration>
    extends BCLConfigureFeature<F, FC> {
        private BCLConfigureFeature<F, FC> registered = null;

        Unregistered(ResourceLocation id, Holder<ConfiguredFeature<FC, F>> configuredFeature) {
            super(id, configuredFeature, false);
        }

        @Override
        public BCLConfigureFeature<F, FC> register(BootstapContext<ConfiguredFeature<?, ?>> bootstrapContext) {
            if (this.registered != null) {
                return this.registered;
            }
            Holder holder = BCLFeatureBuilder.register(bootstrapContext, this.id, (ConfiguredFeature)this.configuredFeature.m_203334_());
            BCLFeatureBuilder.UNBOUND_FEATURES.remove(this);
            this.registered = new BCLConfigureFeature(this.id, holder, true);
            return this.registered;
        }
    }
}

