/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import java.util.Objects;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeContainer;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;

class UnboundBCLBiome<T extends BCLBiome>
extends BCLBiomeContainer<T> {
    private final BCLBiome parentBiome;
    private final BCLBiomeBuilder.BuildCompletion supplier;
    private BCLBiomeContainer<T> registered;

    UnboundBCLBiome(T biome, BCLBiome parentBiome, BCLBiomeBuilder.BuildCompletion supplier) {
        super(biome);
        this.parentBiome = parentBiome;
        this.supplier = supplier;
    }

    @Override
    public BCLBiomeContainer<T> register(BootstapContext<Biome> bootstrapContext, BiomeAPI.BiomeType dim) {
        if (this.registered != null) {
            return this.registered;
        }
        if (dim == null) {
            dim = BiomeAPI.BiomeType.NONE;
        }
        this.biome._setBiomeToRegister((Biome)this.supplier.apply(bootstrapContext));
        if (this.hasParent()) {
            BiomeAPI.registerSubBiome(bootstrapContext, this.parentBiome, this.biome, dim);
        } else if (dim.is(BiomeAPI.BiomeType.END_LAND)) {
            BiomeAPI.registerEndLandBiome(bootstrapContext, this.biome);
        } else if (dim.is(BiomeAPI.BiomeType.END_VOID)) {
            BiomeAPI.registerEndVoidBiome(bootstrapContext, this.biome);
        } else if (dim.is(BiomeAPI.BiomeType.END_BARRENS)) {
            BiomeAPI.registerEndBarrensBiome(bootstrapContext, this.parentBiome, this.biome);
        } else if (dim.is(BiomeAPI.BiomeType.END_CENTER)) {
            BiomeAPI.registerEndCenterBiome(bootstrapContext, this.biome);
        } else if (dim.is(BiomeAPI.BiomeType.NETHER)) {
            BiomeAPI.registerNetherBiome(bootstrapContext, this.biome);
        } else {
            BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, this.biome, dim);
        }
        BCLBiomeBuilder.UNBOUND_BIOMES.remove(this);
        this.registered = new BCLBiomeContainer<BCLBiome>(this.biome);
        return this.registered;
    }

    @Override
    public T biome() {
        return (T)this.biome;
    }

    public boolean hasParent() {
        return this.parentBiome != null;
    }

    public BCLBiome parentBiome() {
        return this.parentBiome;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnboundBCLBiome that = (UnboundBCLBiome)obj;
        return Objects.equals(this.biome, that.biome);
    }

    public int hashCode() {
        return Objects.hash(this.biome);
    }

    public String toString() {
        return "UnregisteredBiome[biome=" + this.biome + "]";
    }
}

