/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.VanillaBiomeSettings;
import org.betterx.bclib.config.Configs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalBiomeAPI {
    public static final BiomeAPI.BiomeType OTHER_NETHER = new BiomeAPI.BiomeType("OTHER_NETHER", BiomeAPI.BiomeType.NETHER);
    public static final BiomeAPI.BiomeType OTHER_END_LAND = new BiomeAPI.BiomeType("OTHER_END_LAND", BiomeAPI.BiomeType.END_LAND);
    public static final BiomeAPI.BiomeType OTHER_END_VOID = new BiomeAPI.BiomeType("OTHER_END_VOID", BiomeAPI.BiomeType.END_VOID);
    public static final BiomeAPI.BiomeType OTHER_END_CENTER = new BiomeAPI.BiomeType("OTHER_END_CENTER", BiomeAPI.BiomeType.END_CENTER);
    public static final BiomeAPI.BiomeType OTHER_END_BARRENS = new BiomeAPI.BiomeType("OTHER_END_BARRENS", BiomeAPI.BiomeType.END_BARRENS);
    static final Map<Biome, BCLBiome> CLIENT = Maps.newHashMap();
    static final Map<Holder<PlacedFeature>, Integer> FEATURE_ORDER = Maps.newHashMap();
    static final Map<HolderGetter<Biome>, AtomicInteger> BIOME_ADDITIONS = Maps.newHashMap();
    static final MutableInt FEATURE_ORDER_ID = new MutableInt(0);
    static final Map<ResourceKey<LevelStem>, List<BiConsumer<ResourceLocation, Holder<Biome>>>> MODIFICATIONS = Maps.newHashMap();
    static final Map<ResourceKey, List<BiConsumer<ResourceLocation, Holder<Biome>>>> TAG_ADDERS = Maps.newHashMap();
    static Registry<Biome> biomeRegistry;
    static RegistryAccess registryAccess;
    private static final Set<ResourceLocation> BIOMES_TO_SORT;

    public static RegistryAccess worldRegistryAccess() {
        return registryAccess;
    }

    public static void initRegistry(RegistryAccess access) {
        if (access != registryAccess) {
            registryAccess = access;
            Registry biomeRegistry = access.m_6632_(Registries.f_256952_).orElse(null);
            if (biomeRegistry != InternalBiomeAPI.biomeRegistry) {
                InternalBiomeAPI.biomeRegistry = biomeRegistry;
                CLIENT.clear();
                BIOMES_TO_SORT.forEach(id -> {
                    Biome b = (Biome)biomeRegistry.m_7745_(id);
                    if (b == null) {
                        BCLib.LOGGER.info("Unknown Biome: " + id);
                    }
                });
            }
        }
    }

    public static void prepareNewLevel() {
        BIOMES_TO_SORT.clear();
    }

    public static void loadFabricAPIBiomes() {
    }

    public static void _runBiomeTagAdders() {
        for (Map.Entry<ResourceKey, List<BiConsumer<ResourceLocation, Holder<Biome>>>> mod : TAG_ADDERS.entrySet()) {
            Stream<ResourceLocation> s = null;
            if (mod.getKey() == Level.f_46429_) {
                s = BCLBiomeRegistry.getAll(BiomeAPI.BiomeType.NETHER).map(k -> k.m_135782_());
            } else if (mod.getKey() == Level.f_46430_) {
                s = BCLBiomeRegistry.getAll(BiomeAPI.BiomeType.END).map(k -> k.m_135782_());
            }
            if (s == null) continue;
            s.forEach(id -> {
                Holder<Biome> biomeHolder = BiomeAPI.getFromRegistry(id);
                if (biomeHolder != null && biomeHolder.m_203633_()) {
                    ((List)mod.getValue()).forEach(c -> c.accept(id, biomeHolder));
                } else {
                    BCLib.LOGGER.info("No Holder for " + id);
                }
            });
        }
    }

    public static void applyModifications(BiomeSource source, ResourceKey<LevelStem> dimension) {
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("\nApply Modifications for " + dimension.m_135782_() + source.toString().replace("\n", "\n    "));
        }
        Set biomes = source.m_207840_();
        List<BiConsumer<ResourceLocation, Holder<Biome>>> modifications = MODIFICATIONS.get(dimension);
        for (Holder biomeHolder : biomes) {
            if (!biomeHolder.m_203633_()) continue;
            InternalBiomeAPI.applyModificationsAndUpdateFeatures(modifications, (Holder<Biome>)biomeHolder);
        }
    }

    private static void applyModificationsAndUpdateFeatures(List<BiConsumer<ResourceLocation, Holder<Biome>>> modifications, Holder<Biome> biome) {
        ResourceLocation biomeID = BiomeAPI.getBiomeID(biome);
        if (modifications != null) {
            modifications.forEach(consumer -> consumer.accept(biomeID, biome));
        }
    }

    public static BCLBiome wrapBiome(ResourceKey<Biome> biomeKey, BiomeAPI.BiomeType type) {
        return InternalBiomeAPI.wrapBiome(biomeKey, -1.0f, type);
    }

    public static BCLBiome wrapBiome(ResourceKey<Biome> biomeKey, float genChance, BiomeAPI.BiomeType type) {
        return InternalBiomeAPI.wrapBiome(biomeKey, genChance < 0.0f ? null : (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build(), type);
    }

    public static BCLBiome wrapBiome(ResourceKey<Biome> biomeKey, BCLBiome edgeBiome, int edgeBiomeSize, float genChance, BiomeAPI.BiomeType type) {
        VanillaBiomeSettings.Builder settings = VanillaBiomeSettings.createVanilla();
        if (genChance >= 0.0f) {
            settings.setGenChance(genChance);
        }
        settings.setEdgeSize(edgeBiomeSize);
        BCLBiome b = InternalBiomeAPI.wrapBiome(biomeKey, (VanillaBiomeSettings)settings.build(), type);
        b._setEdge(edgeBiome);
        return b;
    }

    private static BCLBiome wrapBiome(ResourceKey<Biome> biomeKey, VanillaBiomeSettings setings, BiomeAPI.BiomeType type) {
        Registry<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
        if (BCLBiomeRegistry.hasBiome(biomeKey, reg)) {
            return BCLBiomeRegistry.getBiome(biomeKey, reg);
        }
        BCLBiome bclBiome = new BCLBiome(biomeKey, (BCLBiomeSettings)setings);
        bclBiome._setIntendedType(type);
        InternalBiomeAPI.registerBuiltinBiome(bclBiome);
        return bclBiome;
    }

    public static BCLBiome wrapNativeBiome(ResourceKey<Biome> biomeKey, BiomeAPI.BiomeType type) {
        Registry<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
        if (!BCLBiomeRegistry.hasBiome(biomeKey, reg)) {
            BCLBiome bclBiome = InternalBiomeAPI.wrapBiome(biomeKey, type);
            BCLBiomeRegistry.register(bclBiome);
            InternalBiomeAPI.registerBuiltinBiome(bclBiome);
            return bclBiome;
        }
        return BCLBiomeRegistry.getBiome(biomeKey, reg);
    }

    public static int getBiomeRegistryModificationCount(HolderGetter<Biome> registry) {
        if (registry == null) {
            return 0;
        }
        return BIOME_ADDITIONS.computeIfAbsent(registry, reg -> new AtomicInteger(0)).get();
    }

    public static BCLBiome registerBuiltinBiome(BCLBiome bclbiome) {
        return BiomeAPI.finishBiomeRegistration(bclbiome);
    }

    static {
        BIOMES_TO_SORT = Sets.newHashSet();
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> {
            Optional oBiomeRegistry = registryManager.asDynamicRegistryManager().m_6632_(Registries.f_256952_);
            if (oBiomeRegistry.isPresent()) {
                RegistryEntryAddedCallback.event((Registry)((Registry)oBiomeRegistry.get())).register((rawId, id, biome) -> {
                    BCLBiome b = BiomeAPI.getBiome(id);
                    if ("minecraft".equals(id.m_135827_()) || BCLBiomeRegistry.isEmptyBiome(b)) {
                        // empty if block
                    }
                });
            } else {
                BCLib.LOGGER.warning("No valid Biome Registry available!", new Object[0]);
            }
        });
    }
}

