/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import org.betterx.bclib.mixin.common.MobSpawnSettingsAccessor;
import org.betterx.bclib.util.CollectionsUtil;
import org.betterx.worlds.together.tag.v3.CommonBiomeTags;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeAPI {
    public static final BCLBiome THE_END = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48210_, InternalBiomeAPI.OTHER_END_CENTER);
    public static final BCLBiome NETHER_WASTES_BIOME = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48209_, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome CRIMSON_FOREST_BIOME = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48200_, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome WARPED_FOREST_BIOME = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48201_, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome SOUL_SAND_VALLEY_BIOME = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48199_, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome BASALT_DELTAS_BIOME = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48175_, InternalBiomeAPI.OTHER_NETHER);
    public static final BCLBiome END_MIDLANDS = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48163_, 0.5f, InternalBiomeAPI.OTHER_END_LAND);
    public static final BCLBiome END_HIGHLANDS = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48164_, END_MIDLANDS, 8, 0.5f, InternalBiomeAPI.OTHER_END_LAND);
    public static final BCLBiome END_BARRENS = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48165_, InternalBiomeAPI.OTHER_END_BARRENS);
    public static final BCLBiome SMALL_END_ISLANDS = InternalBiomeAPI.wrapBiome((ResourceKey<Biome>)Biomes.f_48162_, InternalBiomeAPI.OTHER_END_VOID);

    static BCLBiome registerBuiltinBiomeAndOverrideIntendedDimension(BootstapContext<Biome> bootstrapContext, BCLBiome bclbiome, BiomeType dim) {
        bclbiome._setIntendedType(dim);
        return BiomeAPI.registerBiome(bootstrapContext, bclbiome);
    }

    static BCLBiome registerBiome(BootstapContext<Biome> bootstrapContext, BCLBiome bclbiome) {
        HolderGetter registryOrNull = bootstrapContext.m_255420_(Registries.f_256952_);
        if (registryOrNull != null && bclbiome._hasBiomeToRegister() && !registryOrNull.m_254902_(bclbiome.getBiomeKey()).map(v -> v.m_203633_()).orElse(false).booleanValue()) {
            bootstrapContext.m_255272_(bclbiome.getBiomeKey(), (Object)bclbiome._getBiomeToRegister());
            BCLBiomeRegistry.registerForDatagen(bclbiome);
        }
        return BiomeAPI.finishBiomeRegistration(bclbiome);
    }

    static BCLBiome finishBiomeRegistration(BCLBiome bclbiome) {
        BiomeType dim = bclbiome.getIntendedType();
        if (dim != null && dim.is(BiomeType.NETHER)) {
            TagManager.BIOMES.add((TagKey<Biome>)BiomeTags.f_207612_, bclbiome.getBiomeKey());
        } else if (dim != null && dim.is(BiomeType.END)) {
            TagManager.BIOMES.add((TagKey<Biome>)BiomeTags.f_215818_, bclbiome.getBiomeKey());
            if (dim.is(BiomeType.END_VOID)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_SMALL_END_ISLAND, bclbiome.getBiomeKey());
            } else if (dim.is(BiomeType.END_BARRENS)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_END_BARRENS, bclbiome.getBiomeKey());
            } else if (dim.is(BiomeType.END_LAND)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_END_HIGHLAND, bclbiome.getBiomeKey());
            } else if (dim.is(BiomeType.END_CENTER)) {
                TagManager.BIOMES.add(CommonBiomeTags.IS_END_CENTER, bclbiome.getBiomeKey());
            }
        }
        bclbiome.afterRegistration();
        return bclbiome;
    }

    static BCLBiome registerSubBiome(BootstapContext<Biome> bootstrapContext, BCLBiome parent, BCLBiome subBiome) {
        return BiomeAPI.registerSubBiome(bootstrapContext, parent, subBiome, parent.getIntendedType());
    }

    static BCLBiome registerSubBiome(BootstapContext<Biome> bootstrapContext, BCLBiome parent, BCLBiome subBiome, BiomeType dim) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, subBiome, dim);
        parent.addSubBiome(subBiome);
        return subBiome;
    }

    static BCLBiome registerEndLandBiome(BootstapContext<Biome> bootstrapContext, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_LAND);
        float weight = biome.settings.getGenChance();
        ResourceKey<Biome> key = biome.getBiomeKey();
        if (biome.isEdgeBiome()) {
            ResourceKey<Biome> parentKey = biome.getParentBiome().getBiomeKey();
            TheEndBiomes.addMidlandsBiome(parentKey, key, (double)weight);
        } else {
            TheEndBiomes.addHighlandsBiome(key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerEndVoidBiome(BootstapContext<Biome> bootstrapContext, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_VOID);
        float weight = biome.settings.getGenChance();
        ResourceKey<Biome> key = biome.getBiomeKey();
        if (!biome.isEdgeBiome()) {
            TheEndBiomes.addSmallIslandsBiome(key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerEndCenterBiome(BootstapContext<Biome> bootstrapContext, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_CENTER);
        float weight = biome.settings.getGenChance();
        ResourceKey<Biome> key = biome.getBiomeKey();
        if (!biome.isEdgeBiome()) {
            TheEndBiomes.addMainIslandBiome(key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerEndBarrensBiome(BootstapContext<Biome> bootstrapContext, BCLBiome highlandBiome, BCLBiome biome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, biome, BiomeType.BCL_END_BARRENS);
        float weight = biome.settings.getGenChance();
        ResourceKey<Biome> key = biome.getBiomeKey();
        if (!biome.isEdgeBiome()) {
            ResourceKey<Biome> parentKey = highlandBiome.getBiomeKey();
            TheEndBiomes.addBarrensBiome(parentKey, key, (double)weight);
        }
        return biome;
    }

    static BCLBiome registerNetherBiome(BootstapContext<Biome> bootstrapContext, BCLBiome bclBiome) {
        BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension(bootstrapContext, bclBiome, BiomeType.BCL_NETHER);
        ResourceKey<Biome> key = bclBiome.getBiomeKey();
        if (!bclBiome.isEdgeBiome()) {
            bclBiome.forEachClimateParameter(p -> NetherBiomes.addNetherBiome((ResourceKey)key, (Climate.ParameterPoint)p));
        }
        return bclBiome;
    }

    public static BCLBiome getRenderBiome(Biome biome) {
        RegistryAccess acc;
        BCLBiome endBiome = InternalBiomeAPI.CLIENT.get(biome);
        if (endBiome == null && (acc = WorldBootstrap.getLastRegistryAccessOrElseBuiltin()) != null) {
            Registry<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
            ResourceLocation id = acc.m_175515_(Registries.f_256952_).m_7981_((Object)biome);
            endBiome = BCLBiomeRegistry.getBiomeOrEmpty(id, reg);
            InternalBiomeAPI.CLIENT.put(biome, endBiome);
        }
        return endBiome;
    }

    @Nullable
    public static ResourceKey getBiomeKey(Biome biome) {
        Optional key;
        if (InternalBiomeAPI.biomeRegistry != null && (key = InternalBiomeAPI.biomeRegistry.m_7854_((Object)biome)).isPresent()) {
            return (ResourceKey)key.get();
        }
        return null;
    }

    public static ResourceLocation getBiomeID(Biome biome) {
        ResourceKey key;
        ResourceLocation id = null;
        if (InternalBiomeAPI.biomeRegistry != null) {
            id = InternalBiomeAPI.biomeRegistry.m_7981_((Object)biome);
        }
        if (id == null && (key = BiomeAPI.getBiomeKey(biome)) != null) {
            id = key.m_135782_();
        }
        if (id == null) {
            BCLib.LOGGER.error("Unable to get ID for " + biome + ". Falling back to empty Biome...");
            id = BCLBiomeRegistry.EMPTY_BIOME.getID();
        }
        return id;
    }

    public static ResourceLocation getBiomeID(Holder<Biome> biome) {
        return biome.m_203543_().map(h -> h.m_135782_()).orElse(null);
    }

    @Nullable
    public static BCLBiome getBiome(ResourceLocation biomeID) {
        return BCLBiomeRegistry.getBiomeOrNull(biomeID, BCLBiomeRegistry.registryOrNull());
    }

    @Nullable
    public static BCLBiome getBiome(Biome biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    @Nullable
    public static BCLBiome getBiome(Holder<Biome> biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    public static Holder<Biome> getFromRegistry(ResourceLocation biomeID) {
        Registry reg;
        Optional holder;
        if (InternalBiomeAPI.biomeRegistry != null && (holder = InternalBiomeAPI.biomeRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeID))).isPresent()) {
            return (Holder)holder.get();
        }
        if (WorldBootstrap.getLastRegistryAccess() != null && (reg = WorldBootstrap.getLastRegistryAccess().m_175515_(Registries.f_256952_)).m_7804_(biomeID)) {
            return reg.m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeID));
        }
        return null;
    }

    public static boolean wasRegisteredAs(ResourceLocation biomeID, BiomeType dim) {
        if (BCLBiomeRegistry.isEmptyBiome(biomeID)) {
            return false;
        }
        BCLBiome res = BCLBiomeRegistry.getBiomeOrEmpty(biomeID, BCLBiomeRegistry.registryOrNull());
        if (res == null) {
            return false;
        }
        return res.getIntendedType().is(dim);
    }

    public static boolean wasRegisteredAsNetherBiome(ResourceLocation biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.NETHER);
    }

    public static boolean wasRegisteredAsEndBiome(ResourceLocation biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END);
    }

    public static boolean wasRegisteredAsEndLandBiome(ResourceLocation biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_LAND);
    }

    public static boolean wasRegisteredAsEndVoidBiome(ResourceLocation biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_VOID);
    }

    public static boolean wasRegisteredAsEndCenterBiome(ResourceLocation biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_CENTER);
    }

    public static boolean wasRegisteredAsEndBarrensBiome(ResourceLocation biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_BARRENS);
    }

    public static void registerBiomeModification(ResourceKey<LevelStem> dimensionID, BiConsumer<ResourceLocation, Holder<Biome>> modification) {
        List modifications = InternalBiomeAPI.MODIFICATIONS.computeIfAbsent(dimensionID, k -> Lists.newArrayList());
        modifications.add(modification);
    }

    public static void registerOverworldBiomeModification(BiConsumer<ResourceLocation, Holder<Biome>> modification) {
        BiomeAPI.registerBiomeModification((ResourceKey<LevelStem>)LevelStem.f_63971_, modification);
    }

    public static void registerNetherBiomeModification(BiConsumer<ResourceLocation, Holder<Biome>> modification) {
        BiomeAPI.registerBiomeModification((ResourceKey<LevelStem>)LevelStem.f_63972_, modification);
    }

    public static void registerEndBiomeModification(BiConsumer<ResourceLocation, Holder<Biome>> modification) {
        BiomeAPI.registerBiomeModification((ResourceKey<LevelStem>)LevelStem.f_63973_, modification);
    }

    public static void onFinishingBiomeTags(ResourceKey dimensionID, BiConsumer<ResourceLocation, Holder<Biome>> modification) {
        List modifications = InternalBiomeAPI.TAG_ADDERS.computeIfAbsent(dimensionID, k -> Lists.newArrayList());
        modifications.add(modification);
    }

    public static void onFinishingNetherBiomeTags(BiConsumer<ResourceLocation, Holder<Biome>> modification) {
        BiomeAPI.onFinishingBiomeTags(Level.f_46429_, modification);
    }

    public static void onFinishingEndBiomeTags(BiConsumer<ResourceLocation, Holder<Biome>> modification) {
        BiomeAPI.onFinishingBiomeTags(Level.f_46430_, modification);
    }

    public static void addBiomeFeature(Holder<Biome> biome, BCLFeature feature) {
        BiomeAPI.addBiomeFeature(biome, feature.getDecoration(), feature.getPlacedFeature());
    }

    public static void addBiomeFeature(Holder<Biome> biome, GenerationStep.Decoration step, Holder<PlacedFeature> ... featureList) {
        BiomeAPI.addBiomeFeature(biome, step, List.of(featureList));
    }

    private static void addBiomeFeature(Holder<Biome> biome, GenerationStep.Decoration step, List<Holder<PlacedFeature>> additionalFeatures) {
        BiomeGenerationSettingsAccessor accessor = (BiomeGenerationSettingsAccessor)((Biome)biome.m_203334_()).m_47536_();
        List<HolderSet<PlacedFeature>> allFeatures = CollectionsUtil.getMutable(accessor.bclib_getFeatures());
        List<Holder<PlacedFeature>> features = BiomeAPI.getFeaturesListCopy(allFeatures, step);
        for (Holder<PlacedFeature> feature : additionalFeatures) {
            if (features.contains(feature)) continue;
            features.add(feature);
        }
        allFeatures.set(step.ordinal(), (HolderSet<PlacedFeature>)HolderSet.m_205800_(features));
        com.google.common.base.Supplier flowerFeatures = Suppliers.memoize(() -> (List)allFeatures.stream().flatMap(HolderSet::m_203614_).map(Holder::m_203334_).flatMap(PlacedFeature::m_191781_).filter(configuredFeature -> configuredFeature.f_65377_() == Feature.f_65761_).collect(ImmutableList.toImmutableList()));
        com.google.common.base.Supplier featureSet = Suppliers.memoize(() -> allFeatures.stream().flatMap(HolderSet::m_203614_).map(Holder::m_203334_).collect(Collectors.toSet()));
        accessor.bclib_setFeatures(allFeatures);
        accessor.bclib_setFeatureSet((Supplier<Set<PlacedFeature>>)featureSet);
        accessor.bclib_setFlowerFeatures((Supplier<List<ConfiguredFeature<?, ?>>>)flowerFeatures);
    }

    public static <M extends Mob> void addBiomeMobSpawn(Holder<Biome> biome, EntityType<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        MobCategory category = entityType.m_20674_();
        MobSpawnSettingsAccessor accessor = (MobSpawnSettingsAccessor)((Biome)biome.m_203334_()).m_47518_();
        Map<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> spawners = CollectionsUtil.getMutable(accessor.bcl_getSpawners());
        ArrayList mobs = spawners.containsKey(category) ? CollectionsUtil.getMutable(spawners.get(category).m_146338_()) : Lists.newArrayList();
        mobs.add(new MobSpawnSettings.SpawnerData(entityType, weight, minGroupCount, maxGroupCount));
        spawners.put(category, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.m_146328_((List)mobs));
        accessor.bcl_setSpawners(spawners);
    }

    public static Optional<BlockState> findTopMaterial(WorldGenLevel world, BlockPos pos) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((Holder<Biome>)world.m_204166_(pos)));
    }

    public static Optional<BlockState> findTopMaterial(Holder<Biome> biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((Biome)biome.m_203334_()));
    }

    public static Optional<BlockState> findTopMaterial(Biome biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome(biome));
    }

    public static Optional<BlockState> findTopMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getTopMaterial());
        }
        return Optional.empty();
    }

    public static Optional<BlockState> findUnderMaterial(Holder<Biome> biome) {
        return BiomeAPI.findUnderMaterial(BiomeAPI.getBiome((Biome)biome.m_203334_()));
    }

    public static Optional<BlockState> findUnderMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getUnderMaterial());
        }
        return Optional.empty();
    }

    public static void setBiome(ChunkAccess chunk, BlockPos pos, Holder<Biome> biome) {
        int sectionY = pos.m_123342_() - chunk.m_141937_() >> 4;
        PalettedContainerRO biomes = chunk.m_183278_(sectionY).m_187996_();
        if (biomes instanceof PalettedContainer) {
            PalettedContainer palette = (PalettedContainer)biomes;
            palette.m_156470_((pos.m_123341_() & 0xF) >> 2, (pos.m_123342_() & 0xF) >> 2, (pos.m_123343_() & 0xF) >> 2, biome);
        } else {
            BCLib.LOGGER.warning("Unable to change Biome at " + pos, new Object[0]);
        }
    }

    public static void setBiome(LevelAccessor level, BlockPos pos, Holder<Biome> biome) {
        ChunkAccess chunk = level.m_46865_(pos);
        BiomeAPI.setBiome(chunk, pos, biome);
    }

    private static List<Holder<PlacedFeature>> getFeaturesListCopy(List<HolderSet<PlacedFeature>> features, GenerationStep.Decoration step) {
        return BiomeAPI.getFeaturesListCopy(features, step.ordinal());
    }

    private static List<Holder<PlacedFeature>> getFeaturesListCopy(List<HolderSet<PlacedFeature>> features, int index) {
        while (features.size() <= index) {
            features.add((HolderSet<PlacedFeature>)HolderSet.m_205800_((List)Lists.newArrayList()));
        }
        return features.get(index).m_203614_().collect(Collectors.toList());
    }

    public static List<BCLBiome> getAllBiomes(BiomeType type) {
        ArrayList<BCLBiome> res = new ArrayList<BCLBiome>();
        RegistryAccess access = WorldBootstrap.getLastRegistryAccess();
        Registry reg = access == null ? BCLBiomeRegistry.BUILTIN_BCL_BIOMES : access.m_175515_(BCLBiomeRegistry.BCL_BIOMES_REGISTRY);
        for (Map.Entry e : reg.m_6579_()) {
            if (!((BCLBiome)e.getValue()).getIntendedType().is(type)) continue;
            res.add((BCLBiome)e.getValue());
        }
        return res;
    }

    public static class BiomeType {
        public static final Codec<BiomeType> DIRECT_CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.STRING.fieldOf("name").orElse((Object)"undefined").forGetter(o -> o.name)).apply((Applicative)instance, BiomeType::create));
        public static final Codec<BiomeType> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.STRING.fieldOf("name").orElse((Object)"undefined").forGetter(o -> o.name), (App)Codec.STRING.fieldOf("parent").orElse((Object)"none").forGetter(o -> o.parentOrNull == null ? "none" : o.parentOrNull.name)).apply((Applicative)instance, BiomeType::create));
        private static final Map<String, BiomeType> KNOWN_TYPES = new HashMap<String, BiomeType>();
        public static final BiomeType NONE = new BiomeType("NONE");
        public static final BiomeType OVERWORLD = new BiomeType("OVERWORLD");
        public static final BiomeType NETHER = new BiomeType("NETHER");
        public static final BiomeType BCL_NETHER = new BiomeType("BCL_NETHER", NETHER, (biome, ignored) -> {
            ResourceKey<Biome> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                biome.forEachClimateParameter(p -> NetherBiomes.addNetherBiome((ResourceKey)key, (Climate.ParameterPoint)p));
            }
        });
        public static final BiomeType END = new BiomeType("END");
        public static final BiomeType END_IGNORE = new BiomeType("END_IGNORE", END);
        public static final BiomeType END_LAND = new BiomeType("END_LAND", END);
        public static final BiomeType END_VOID = new BiomeType("END_VOID", END);
        public static final BiomeType END_CENTER = new BiomeType("END_CENTER", END);
        public static final BiomeType END_BARRENS = new BiomeType("END_BARRENS", END);
        public static final BiomeType BCL_END_LAND = new BiomeType("BCL_END_LAND", END_LAND, (biome, ignored) -> {
            float weight = biome.settings.getGenChance();
            ResourceKey<Biome> key = biome.getBiomeKey();
            if (biome.isEdgeBiome()) {
                ResourceKey<Biome> parentKey = biome.getParentBiome().getBiomeKey();
                TheEndBiomes.addMidlandsBiome(parentKey, key, (double)weight);
            } else {
                TheEndBiomes.addHighlandsBiome(key, (double)weight);
            }
        });
        public static final BiomeType BCL_END_VOID = new BiomeType("BCL_END_VOID", END_VOID, (biome, ignored) -> {
            float weight = biome.settings.getGenChance();
            ResourceKey<Biome> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                TheEndBiomes.addSmallIslandsBiome(key, (double)weight);
            }
        });
        public static final BiomeType BCL_END_CENTER = new BiomeType("BCL_END_CENTER", END_CENTER, (biome, ignored) -> {
            float weight = biome.settings.getGenChance();
            ResourceKey<Biome> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                TheEndBiomes.addMainIslandBiome(key, (double)weight);
            }
        });
        public static final BiomeType BCL_END_BARRENS = new BiomeType("BCL_END_BARRENS", END_BARRENS, (biome, highlandBiome) -> {
            float weight = biome.settings.getGenChance();
            ResourceKey<Biome> key = biome.getBiomeKey();
            if (!biome.isEdgeBiome()) {
                ResourceKey<Biome> parentKey = highlandBiome.getBiomeKey();
                TheEndBiomes.addBarrensBiome(parentKey, key, (double)weight);
            }
        });
        public final BiomeType parentOrNull;
        private final String name;
        final ExtraRegisterTaks extraRegisterTask;

        public static BiomeType getMainBiomeTypeForDimension(ResourceKey<LevelStem> key) {
            if (key.equals((Object)LevelStem.f_63973_)) {
                return END_LAND;
            }
            if (key.equals((Object)LevelStem.f_63972_)) {
                return NETHER;
            }
            if (key.equals((Object)LevelStem.f_63971_)) {
                return OVERWORLD;
            }
            return null;
        }

        private static BiomeType create(String name, String parentOrNull) {
            BiomeType parent;
            BiomeType known = KNOWN_TYPES.get(name);
            BiomeType biomeType = parent = parentOrNull == null || "none".equals(parentOrNull) ? null : KNOWN_TYPES.get(parentOrNull);
            if (known != null) {
                if (known.parentOrNull != parent) {
                    BCLib.LOGGER.warning("BiomeType " + name + " was deserialized with parent " + parent + " but already has " + known.parentOrNull, new Object[0]);
                }
                return known;
            }
            return new BiomeType(name, parent);
        }

        static BiomeType create(String name) {
            BiomeType known = KNOWN_TYPES.get(name);
            if (known != null) {
                return known;
            }
            return NONE;
        }

        public BiomeType(String name) {
            this(name, null);
        }

        public BiomeType(String name, BiomeType parentOrNull) {
            this(name, parentOrNull, (b, a) -> {});
        }

        public BiomeType(String name, BiomeType parentOrNull, ExtraRegisterTaks extraRegisterTask) {
            this.parentOrNull = parentOrNull;
            this.name = name;
            this.extraRegisterTask = extraRegisterTask;
            KNOWN_TYPES.put(name, this);
        }

        public boolean is(BiomeType d) {
            if (d == this) {
                return true;
            }
            if (this.parentOrNull != null) {
                return this.parentOrNull.is(d);
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            Object str = this.name;
            if (this.parentOrNull != null) {
                str = (String)str + " -> " + this.parentOrNull;
            }
            return str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BiomeType biomeType = (BiomeType)o;
            return this.name.equals(biomeType.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        @FunctionalInterface
        static interface ExtraRegisterTaks {
            public void register(@NotNull BCLBiome var1, @Nullable BCLBiome var2);
        }
    }
}

