/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoFileSyncEntry;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.util.Pair;
import org.betterx.worlds.together.util.PathUtil;

public class SendFiles
extends DataHandler.FromServer {
    public static final DataHandlerDescriptor DESCRIPTOR = new DataHandlerDescriptor(new ResourceLocation("bclib", "send_files"), SendFiles::new, false, false);
    protected List<AutoFileSyncEntry> files;
    private String token;
    private List<Pair<AutoFileSyncEntry, byte[]>> receivedFiles;

    public SendFiles() {
        this(null, "");
    }

    public SendFiles(List<AutoFileSyncEntry> files, String token) {
        super(SendFiles.DESCRIPTOR.IDENTIFIER);
        this.files = files;
        this.token = token;
    }

    @Override
    protected boolean prepareDataOnServer() {
        if (!Configs.SERVER_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the server.");
            return false;
        }
        return true;
    }

    @Override
    protected void serializeDataOnServer(FriendlyByteBuf buf) {
        List existingFiles = this.files.stream().filter(e -> e != null && e.fileName != null && e.fileName.exists()).collect(Collectors.toList());
        SendFiles.writeString(buf, this.token);
        buf.writeInt(existingFiles.size());
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("Sending " + existingFiles.size() + " Files to Client:");
        }
        for (AutoFileSyncEntry entry : existingFiles) {
            int length = entry.serializeContent(buf);
            if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
            BCLib.LOGGER.info("\t- " + entry + " (" + PathUtil.humanReadableFileSize(length) + ")");
        }
    }
}

