/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoFileSyncEntry;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSync;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSyncID;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SendFiles;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SyncFolderDescriptor;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.config.ServerConfig;
import org.betterx.worlds.together.util.ModUtil;
import org.betterx.worlds.together.util.PathUtil;

public class HelloClient
extends DataHandler.FromServer {
    public static final DataHandlerDescriptor DESCRIPTOR = new DataHandlerDescriptor(new ResourceLocation("bclib", "hello_client"), HelloClient::new, false, false);
    String bclibVersion = "0.0.0";
    IServerModMap modVersion = new ServerModMap();
    List<AutoSync.AutoSyncTriple> autoSyncedFiles = null;
    List<SyncFolderDescriptor> autoSynFolders = null;
    boolean serverPublishedModInfo = false;

    public HelloClient() {
        super(HelloClient.DESCRIPTOR.IDENTIFIER);
    }

    static String getBCLibVersion() {
        return ModUtil.getModVersion("bclib");
    }

    @Override
    protected boolean prepareDataOnServer() {
        if (!Configs.SERVER_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the server.");
            return false;
        }
        AutoSync.loadSyncFolder();
        return true;
    }

    @Override
    protected void serializeDataOnServer(FriendlyByteBuf buf) {
        String vbclib = HelloClient.getBCLibVersion();
        BCLib.LOGGER.info("Sending Hello to Client. (server=" + vbclib + ")");
        buf.writeInt(ModUtil.convertModVersion(vbclib));
        if (Configs.SERVER_CONFIG.isOfferingMods() || Configs.SERVER_CONFIG.isOfferingInfosForMods()) {
            List<String> mods = DataExchangeAPI.registeredMods();
            List<String> inmods = mods;
            if (Configs.SERVER_CONFIG.isOfferingAllMods() || Configs.SERVER_CONFIG.isOfferingInfosForMods()) {
                mods = new ArrayList<String>(inmods.size());
                mods.addAll(inmods);
                mods.addAll(ModUtil.getMods().entrySet().stream().filter(entry -> ((ModUtil.ModInfo)entry.getValue()).metadata.getEnvironment() != ModEnvironment.SERVER && !inmods.contains(entry.getKey())).map(entry -> (String)entry.getKey()).collect(Collectors.toList()));
            }
            mods = mods.stream().filter(entry -> !Configs.SERVER_CONFIG.get(ServerConfig.EXCLUDED_MODS).contains(entry)).collect(Collectors.toList());
            buf.writeInt(mods.size());
            for (String modID : mods) {
                String ver = ModUtil.getModVersion(modID);
                int size = 0;
                ModUtil.ModInfo mi = ModUtil.getModInfo(modID);
                if (mi != null) {
                    try {
                        size = (int)Files.size(mi.jarPath);
                    }
                    catch (IOException e2) {
                        BCLib.LOGGER.error("Unable to get File Size: " + e2.getMessage());
                    }
                }
                HelloClient.writeString(buf, modID);
                buf.writeInt(ModUtil.convertModVersion(ver));
                buf.writeInt(size);
                boolean canDownload = size > 0 && Configs.SERVER_CONFIG.isOfferingMods() && (Configs.SERVER_CONFIG.isOfferingAllMods() || inmods.contains(modID));
                buf.writeBoolean(canDownload);
                if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
                BCLib.LOGGER.info("\t- Listing Mod " + modID + " v" + ver + " (size: " + PathUtil.humanReadableFileSize(size) + ", download=" + canDownload + ")");
            }
        } else {
            BCLib.LOGGER.info("Server will not list Mods.");
            buf.writeInt(0);
        }
        if (Configs.SERVER_CONFIG.isOfferingFiles() || Configs.SERVER_CONFIG.isOfferingConfigs()) {
            List existingAutoSyncFiles = AutoSync.getAutoSyncFiles().stream().filter(e -> e.fileName.exists()).filter(e -> e.isConfigFile() && Configs.SERVER_CONFIG.isOfferingConfigs() || e instanceof AutoFileSyncEntry.ForDirectFileRequest && Configs.SERVER_CONFIG.isOfferingFiles()).collect(Collectors.toList());
            buf.writeInt(existingAutoSyncFiles.size());
            for (AutoFileSyncEntry entry2 : existingAutoSyncFiles) {
                entry2.serialize(buf);
                if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
                BCLib.LOGGER.info("\t- Offering " + (entry2.isConfigFile() ? "Config " : "File ") + entry2);
            }
        } else {
            BCLib.LOGGER.info("Server will neither offer Files nor Configs.");
            buf.writeInt(0);
        }
        if (Configs.SERVER_CONFIG.isOfferingFiles()) {
            buf.writeInt(AutoSync.syncFolderDescriptions.size());
            AutoSync.syncFolderDescriptions.forEach(desc -> {
                if (Configs.MAIN_CONFIG.verboseLogging()) {
                    BCLib.LOGGER.info("\t- Offering Folder " + desc.localFolder + " (allowDelete=" + desc.removeAdditionalFiles + ")");
                }
                desc.serialize(buf);
            });
        } else {
            BCLib.LOGGER.info("Server will not offer Sync Folders.");
            buf.writeInt(0);
        }
        buf.writeBoolean(Configs.SERVER_CONFIG.isOfferingInfosForMods());
    }

    @Override
    protected boolean isBlocking() {
        return true;
    }

    private void processOfferedFile(List<AutoSyncID> requestFiles, AutoSyncID aid) {
        if (aid instanceof AutoSyncID.WithContentOverride) {
            AutoSyncID.WithContentOverride aidc = (AutoSyncID.WithContentOverride)aid;
            BCLib.LOGGER.info("\t- " + aid + " (updating Content)");
            SendFiles.writeSyncedFile((AutoSyncID)aid, (byte[])aidc.contentWrapper.getRawContent(), (File)aidc.localFile);
        } else {
            requestFiles.add(aid);
            BCLib.LOGGER.info("\t- " + aid + " (requesting)");
        }
    }

    private void requestBCLibDownload() {
        BCLib.LOGGER.warning("Starting download of BCLib", new Object[0]);
        this.requestFileDownloads(List.of(new AutoSyncID.ForModFileRequest("bclib", this.bclibVersion)));
    }

    public static class ServerModMap
    extends HashMap<String, OfferedModInfo>
    implements IServerModMap {
    }

    public static interface IServerModMap
    extends Map<String, OfferedModInfo> {
    }

    public record OfferedModInfo(String version, int size, boolean canDownload) {
    }
}

