/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.Chunker;

public abstract class DataHandler
extends BaseDataHandler {
    protected DataHandler(ResourceLocation identifier, boolean originatesOnServer) {
        super(identifier, originatesOnServer);
    }

    protected boolean prepareData(boolean isClient) {
        return true;
    }

    protected abstract void serializeData(FriendlyByteBuf var1, boolean var2);

    protected abstract void deserializeIncomingData(FriendlyByteBuf var1, PacketSender var2, boolean var3);

    protected abstract void runOnGameThread(Minecraft var1, MinecraftServer var2, boolean var3);

    @Override
    void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, FriendlyByteBuf buf, PacketSender responseSender) {
        super.receiveFromClient(server, player, handler, buf, responseSender);
        this.deserializeIncomingData(buf, responseSender, false);
        Runnable runner = () -> this.runOnGameThread(null, server, false);
        if (this.isBlocking()) {
            server.m_18709_(runner);
        } else {
            server.execute(runner);
        }
    }

    @Override
    void sendToClient(MinecraftServer server) {
        if (this.prepareData(false)) {
            FriendlyByteBuf buf = PacketByteBufs.create();
            this.serializeData(buf, false);
            DataHandler._sendToClient(this.getIdentifier(), server, PlayerLookup.all((MinecraftServer)server), buf);
        }
    }

    @Override
    void sendToClient(MinecraftServer server, ServerPlayer player) {
        if (this.prepareData(false)) {
            FriendlyByteBuf buf = PacketByteBufs.create();
            this.serializeData(buf, false);
            DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), buf);
        }
    }

    public static void _sendToClient(ResourceLocation identifier, MinecraftServer server, Collection<ServerPlayer> players, FriendlyByteBuf buf) {
        if (buf.readableBytes() > 0x100000) {
            Chunker.PacketChunkSender sender = new Chunker.PacketChunkSender(buf, identifier);
            sender.sendChunks(players);
        } else {
            for (ServerPlayer player : players) {
                ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)identifier, (FriendlyByteBuf)buf);
            }
        }
    }

    public static abstract class FromServer
    extends BaseDataHandler {
        protected FromServer(ResourceLocation identifier) {
            super(identifier, true);
        }

        protected boolean prepareDataOnServer() {
            return true;
        }

        protected abstract void serializeDataOnServer(FriendlyByteBuf var1);

        @Override
        final void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, FriendlyByteBuf buf, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, buf, responseSender);
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the server!");
        }

        public void receiveFromMemory(FriendlyByteBuf buf) {
            this.receiveFromServer(Minecraft.m_91087_(), null, buf, null);
        }

        @Override
        final void sendToClient(MinecraftServer server) {
            if (this.prepareDataOnServer()) {
                FriendlyByteBuf buf = PacketByteBufs.create();
                this.serializeDataOnServer(buf);
                DataHandler._sendToClient(this.getIdentifier(), server, PlayerLookup.all((MinecraftServer)server), buf);
            }
        }

        @Override
        final void sendToClient(MinecraftServer server, ServerPlayer player) {
            if (this.prepareDataOnServer()) {
                FriendlyByteBuf buf = PacketByteBufs.create();
                this.serializeDataOnServer(buf);
                DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), buf);
            }
        }

        public static abstract class WithoutPayload
        extends FromServer {
            protected WithoutPayload(ResourceLocation identifier) {
                super(identifier);
            }

            @Override
            protected boolean prepareDataOnServer() {
                return true;
            }

            @Override
            protected void serializeDataOnServer(FriendlyByteBuf buf) {
            }

            protected void deserializeIncomingDataOnClient(FriendlyByteBuf buf, PacketSender responseSender) {
            }
        }
    }

    public static abstract class FromClient
    extends BaseDataHandler {
        protected FromClient(ResourceLocation identifier) {
            super(identifier, false);
        }

        protected abstract void deserializeIncomingDataOnServer(FriendlyByteBuf var1, Player var2, PacketSender var3);

        protected abstract void runOnServerGameThread(MinecraftServer var1, Player var2);

        @Override
        void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, FriendlyByteBuf buf, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, buf, responseSender);
            this.deserializeIncomingDataOnServer(buf, (Player)player, responseSender);
            Runnable runner = () -> this.runOnServerGameThread(server, (Player)player);
            if (this.isBlocking()) {
                server.m_18709_(runner);
            } else {
                server.execute(runner);
            }
        }

        @Override
        void sendToClient(MinecraftServer server) {
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the client!");
        }

        @Override
        void sendToClient(MinecraftServer server, ServerPlayer player) {
            BCLib.LOGGER.error("[Internal Error] The message '" + this.getIdentifier() + "' must originate from the client!");
        }

        public static abstract class WithoutPayload
        extends FromClient {
            protected WithoutPayload(ResourceLocation identifier) {
                super(identifier);
            }

            protected boolean prepareDataOnClient() {
                return true;
            }

            protected void serializeDataOnClient(FriendlyByteBuf buf) {
            }

            @Override
            protected void deserializeIncomingDataOnServer(FriendlyByteBuf buf, Player player, PacketSender responseSender) {
            }
        }
    }

    public static abstract class WithoutPayload
    extends DataHandler {
        protected WithoutPayload(ResourceLocation identifier, boolean originatesOnServer) {
            super(identifier, originatesOnServer);
        }

        @Override
        protected boolean prepareData(boolean isClient) {
            return true;
        }

        @Override
        protected void serializeData(FriendlyByteBuf buf, boolean isClient) {
        }

        @Override
        protected void deserializeIncomingData(FriendlyByteBuf buf, PacketSender responseSender, boolean isClient) {
        }
    }
}

