/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.ConnectorServerside;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.SyncFileHash;
import org.betterx.bclib.api.v2.dataexchange.handler.DataExchange;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSync;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSyncID;
import org.betterx.bclib.config.Config;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.util.ModUtil;

public class DataExchangeAPI
extends DataExchange {
    private static final List<String> MODS = Lists.newArrayList();

    @Override
    protected ConnectorServerside serverSupplier(DataExchange api) {
        return new ConnectorServerside(api);
    }

    public static void registerMod(String modID) {
        if (!MODS.contains(modID)) {
            MODS.add(modID);
        }
    }

    public static void registerModDependency(String modID) {
        if (ModUtil.getModInfo(modID, false) != null && !"0.0.0".equals(ModUtil.getModVersion(modID))) {
            DataExchangeAPI.registerMod(modID);
        } else if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("Mod Dependency '" + modID + "' not found. This is probably OK.");
        }
    }

    public static List<String> registeredMods() {
        return MODS;
    }

    public static void registerDescriptor(DataHandlerDescriptor desc) {
        DataExchangeAPI api = DataExchange.getInstance();
        api.getDescriptors().add(desc);
    }

    public static void registerDescriptors(List<DataHandlerDescriptor> desc) {
        DataExchangeAPI api = DataExchange.getInstance();
        api.getDescriptors().addAll(desc);
    }

    public static void send(BaseDataHandler h) {
        if (h.getOriginatesOnServer()) {
            DataExchangeAPI.getInstance().server.sendToClient(h);
        } else {
            DataExchangeAPI.getInstance().client.sendToServer(h);
        }
    }

    public static void addAutoSyncFile(String modID, File fileName) {
        AutoSync.addAutoSyncFileData(modID, fileName, false, SyncFileHash.NEED_TRANSFER);
    }

    public static void addAutoSyncFile(String modID, String uniqueID, File fileName) {
        AutoSync.addAutoSyncFileData(modID, uniqueID, fileName, false, SyncFileHash.NEED_TRANSFER);
    }

    public static void addAutoSyncFile(String modID, File fileName, AutoSync.NeedTransferPredicate needTransfer) {
        AutoSync.addAutoSyncFileData(modID, fileName, true, needTransfer);
    }

    public static void addAutoSyncFile(String modID, String uniqueID, File fileName, AutoSync.NeedTransferPredicate needTransfer) {
        AutoSync.addAutoSyncFileData(modID, uniqueID, fileName, true, needTransfer);
    }

    public static void addOnWriteCallback(BiConsumer<AutoSyncID, File> callback) {
        AutoSync.addOnWriteCallback(callback);
    }

    public static File getModSyncFolder(String modID) {
        File fl = AutoSync.SYNC_FOLDER.localFolder.resolve(modID.replace(".", "-").replace(":", "-").replace("\\", "-").replace("/", "-")).normalize().toFile();
        if (!fl.exists()) {
            fl.mkdirs();
        }
        return fl;
    }

    static {
        DataExchangeAPI.addOnWriteCallback(Config::reloadSyncedConfig);
    }
}

