/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataHandler {
    private final boolean originatesOnServer;
    @NotNull
    private final ResourceLocation identifier;
    private ServerPlayer lastMessageSender;

    protected BaseDataHandler(ResourceLocation identifier, boolean originatesOnServer) {
        this.originatesOnServer = originatesOnServer;
        this.identifier = identifier;
    }

    public final boolean getOriginatesOnServer() {
        return this.originatesOnServer;
    }

    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, FriendlyByteBuf buf, PacketSender responseSender) {
        this.lastMessageSender = player;
    }

    protected final boolean reply(BaseDataHandler message, MinecraftServer server) {
        if (this.lastMessageSender == null) {
            return false;
        }
        message.sendToClient(server, this.lastMessageSender);
        return true;
    }

    abstract void sendToClient(MinecraftServer var1);

    abstract void sendToClient(MinecraftServer var1, ServerPlayer var2);

    protected boolean isBlocking() {
        return false;
    }

    public String toString() {
        return "BasDataHandler{originatesOnServer=" + this.originatesOnServer + ", identifier=" + this.identifier + "}";
    }

    public static void writeString(FriendlyByteBuf buf, String s) {
        buf.m_130087_(s.getBytes(StandardCharsets.UTF_8));
    }

    public static String readString(FriendlyByteBuf buf) {
        byte[] data = buf.m_130052_();
        return new String(data, StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseDataHandler)) {
            return false;
        }
        BaseDataHandler that = (BaseDataHandler)o;
        return this.originatesOnServer == that.originatesOnServer && this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.originatesOnServer, this.identifier);
    }
}

