/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.ComposterAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.behaviours.interfaces.BehaviourClimable;
import org.betterx.bclib.behaviours.interfaces.BehaviourCompostable;
import org.betterx.bclib.behaviours.interfaces.BehaviourImmobile;
import org.betterx.bclib.behaviours.interfaces.BehaviourLeaves;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourOre;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.behaviours.interfaces.BehaviourPortalFrame;
import org.betterx.bclib.behaviours.interfaces.BehaviourSaplingLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourSeedLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourShearablePlant;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlantLike;
import org.betterx.bclib.behaviours.interfaces.BlockBehaviour;
import org.betterx.bclib.blocks.BaseBarrelBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.Fuel;
import org.betterx.bclib.interfaces.PostInitable;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.bclib.interfaces.tools.AddMineableHammer;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.interfaces.tools.AddMineableShovel;
import org.betterx.bclib.interfaces.tools.AddMineableSword;
import org.betterx.bclib.interfaces.tools.HasMinableBehaviour;
import org.betterx.bclib.interfaces.tools.PreventMineableAdd;
import org.betterx.bclib.items.tool.BaseAxeItem;
import org.betterx.bclib.items.tool.BaseHoeItem;
import org.betterx.bclib.items.tool.BasePickaxeItem;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.items.tool.BaseShovelItem;
import org.betterx.bclib.items.tool.BaseSwordItem;
import org.betterx.bclib.networking.VersionChecker;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.MineableTags;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.tag.v3.ToolTags;

public class PostInitAPI {
    private static List<Consumer<Boolean>> postInitFunctions = Lists.newArrayList();
    private static List<TagKey<Block>> blockTags = Lists.newArrayList();
    private static List<TagKey<Item>> itemTags = Lists.newArrayList();

    public static void register(Consumer<Boolean> function) {
        postInitFunctions.add(function);
    }

    public static void postInit(boolean isClient) {
        BuiltInRegistries.f_256975_.forEach(block -> {
            PostInitAPI.processBlockCommon(block);
            if (isClient) {
                PostInitAPI.processBlockClient((Block)block);
            }
        });
        BuiltInRegistries.f_257033_.forEach(item -> PostInitAPI.processItemCommon(item));
        if (postInitFunctions != null) {
            postInitFunctions.forEach(function -> function.accept(isClient));
            postInitFunctions = null;
        }
        blockTags = null;
        itemTags = null;
        InternalBiomeAPI.loadFabricAPIBiomes();
        Configs.BIOMES_CONFIG.saveChanges();
        VersionChecker.startCheck(isClient);
    }

    private static void processItemCommon(Item item) {
        if (item instanceof TagProvider) {
            TagProvider provider = (TagProvider)item;
            try {
                provider.addTags(null, itemTags);
            }
            catch (NullPointerException ex) {
                BCLib.LOGGER.error(item + " probably tried to access blockTags.", ex);
            }
            itemTags.forEach(tag -> TagManager.ITEMS.add(tag, item));
            itemTags.clear();
        }
        if (item instanceof BaseShovelItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_SHOVELS, ItemTags.f_271138_);
        } else if (item instanceof BaseSwordItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_SWORDS, ItemTags.f_271388_);
        } else if (item instanceof BasePickaxeItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_PICKAXES, ItemTags.f_271360_);
        } else if (item instanceof BaseAxeItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_AXES, ItemTags.f_271207_);
        } else if (item instanceof BaseHoeItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_HOES, ItemTags.f_271298_);
        } else if (item instanceof BaseShearsItem) {
            TagManager.ITEMS.add(item, ToolTags.FABRIC_SHEARS, CommonItemTags.SHEARS);
            DispenserBlock.m_52672_((ItemLike)item.m_5456_(), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        }
    }

    private static void processBlockCommon(Block block) {
        ResourceLocation location;
        BlockBehaviour c;
        Item item = block.m_5456_();
        if (block instanceof PostInitable) {
            ((PostInitable)block).postInit();
        }
        if (block instanceof TagProvider) {
            ((TagProvider)block).addTags(blockTags, itemTags);
            blockTags.forEach(tag -> TagManager.BLOCKS.add((TagKey<Block>)tag, (Block[])new Block[]{block}));
            if (item != null && item != Items.f_41852_) {
                itemTags.forEach(tag -> TagManager.ITEMS.add(tag, item));
            }
            blockTags.clear();
            itemTags.clear();
        }
        if (block instanceof BaseChestBlock) {
            BaseBlockEntities.CHEST.registerBlock(block);
        } else if (block instanceof BaseBarrelBlock) {
            BaseBlockEntities.BARREL.registerBlock(block);
        } else if (block instanceof BaseFurnaceBlock) {
            BaseBlockEntities.FURNACE.registerBlock(block);
        }
        if (!(block instanceof PreventMineableAdd)) {
            if (block instanceof AddMineableShears) {
                TagManager.BLOCKS.add(block, MineableTags.SHEARS);
            }
            if (!(!(block instanceof AddMineableAxe) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13095_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13092_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13097_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13098_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13096_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13100_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13102_, block) || TagManager.BLOCKS.contains(CommonBlockTags.WOODEN_BARREL, block) || TagManager.BLOCKS.contains(CommonBlockTags.WOODEN_CHEST, block) || TagManager.BLOCKS.contains(CommonBlockTags.WOODEN_COMPOSTER, block) || TagManager.BLOCKS.contains(CommonBlockTags.WORKBENCHES, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13068_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13090_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13106_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_13055_, block) || TagManager.BLOCKS.contains((TagKey<Block>)BlockTags.f_244320_, block) || TagManager.BLOCKS.contains(CommonBlockTags.WORKBENCHES, block) || TagManager.BLOCKS.contains(CommonBlockTags.BOOKSHELVES, block))) {
                TagManager.BLOCKS.add(block, MineableTags.AXE);
            }
            if (block instanceof AddMineablePickaxe) {
                TagManager.BLOCKS.add(block, MineableTags.PICKAXE);
            }
            if (block instanceof AddMineableShovel) {
                TagManager.BLOCKS.add(block, MineableTags.SHOVEL);
            }
            if (block instanceof AddMineableHoe) {
                TagManager.BLOCKS.add(block, MineableTags.HOE);
            }
            if (block instanceof AddMineableSword) {
                TagManager.BLOCKS.add(block, MineableTags.SWORD);
            }
            if (block instanceof AddMineableHammer) {
                TagManager.BLOCKS.add(block, MineableTags.HAMMER);
            }
        }
        if (block instanceof BehaviourCompostable) {
            c = (BehaviourCompostable)block;
            if (item != null && item != Items.f_41852_) {
                TagManager.ITEMS.add((ItemLike)block, CommonItemTags.COMPOSTABLE);
                ComposterAPI.allowCompost(c.compostingChance(), item);
            } else if (BCLib.isDatagen() && Configs.MAIN_CONFIG.verboseLogging()) {
                BCLib.LOGGER.warning("Block " + block + " has compostable behaviour but no item!", new Object[0]);
            }
        }
        if (block instanceof BehaviourWaterPlantLike) {
            TagManager.BLOCKS.add(block, CommonBlockTags.WATER_PLANT);
        }
        if (block instanceof BehaviourPlant || block instanceof BehaviourShearablePlant) {
            TagManager.BLOCKS.add(block, CommonBlockTags.PLANT);
        }
        if (block instanceof BehaviourSeedLike) {
            TagManager.BLOCKS.add(block, CommonBlockTags.SEEDS);
            if (item != null && item != Items.f_41852_) {
                TagManager.ITEMS.add((ItemLike)block, CommonItemTags.SEEDS);
            }
        }
        if (block instanceof BehaviourSaplingLike) {
            TagManager.BLOCKS.add(block, CommonBlockTags.SAPLINGS, BlockTags.f_13104_);
            if (item != null && item != Items.f_41852_) {
                TagManager.ITEMS.add((ItemLike)block, CommonItemTags.SAPLINGS, ItemTags.f_13180_);
            }
        }
        if (block instanceof BehaviourClimable) {
            c = (BehaviourClimable)block;
            TagManager.BLOCKS.add(block, BlockTags.f_13082_);
        }
        if (block instanceof BehaviourLeaves) {
            TagManager.BLOCKS.add(block, BlockTags.f_13035_, CommonBlockTags.LEAVES);
            if (item != null && item != Items.f_41852_) {
                TagManager.ITEMS.add(item, ItemTags.f_13143_, CommonItemTags.LEAVES);
            }
        }
        if (block instanceof BehaviourImmobile) {
            TagManager.BLOCKS.add(block, CommonBlockTags.IMMOBILE);
        }
        if (block instanceof BehaviourObsidian) {
            TagManager.BLOCKS.add(block, CommonBlockTags.IS_OBSIDIAN);
        }
        if (block instanceof BehaviourPortalFrame) {
            TagManager.BLOCKS.add(block, CommonBlockTags.NETHER_PORTAL_FRAME);
        }
        if (block instanceof BehaviourOre) {
            TagManager.BLOCKS.add(block, CommonBlockTags.ORES);
        }
        if (block instanceof Fuel) {
            Fuel fl = (Fuel)block;
            FuelRegistry.INSTANCE.add((ItemLike)block, (Object)fl.getFuelTime());
        }
        if (BCLib.isDatagen() && !(location = BuiltInRegistries.f_256975_.m_7981_((Object)block)).m_135827_().equals("minecraft") && !(block instanceof HasMinableBehaviour) && block.m_49966_().m_60834_()) {
            BCLib.LOGGER.error("Block " + block + "(" + block.getClass() + ") has no mineable behaviour!");
        }
    }
}

